/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.ext.git;

import io.warp10.ext.git.GitWarpScriptExtension;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import io.warp10.warp.sdk.Capabilities;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.eclipse.jgit.api.AddCommand;
import org.eclipse.jgit.api.CommitCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.EmptyCommitException;
import org.eclipse.jgit.revwalk.RevCommit;

public class GITSTORE
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    public GITSTORE(String name) {
        super(name);
    }

    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object top = stack.pop();
        if (!(top instanceof Map)) {
            throw new WarpScriptException(this.getName() + " expects a parameter MAP.");
        }
        Map params = (Map)top;
        if (!(params.get("message") instanceof String)) {
            throw new WarpScriptException(this.getName() + " expects a commit message under key '" + "message" + "'.");
        }
        String message = (String)params.get("message");
        if (!(params.get("path") instanceof String)) {
            throw new WarpScriptException(this.getName() + " unset path under key '" + "path" + "'.");
        }
        String path = (String)params.get("path");
        if (!(params.get("repo") instanceof String)) {
            throw new WarpScriptException(this.getName() + " unset repository under key '" + "repo" + "'.");
        }
        boolean noworkdir = Boolean.FALSE.equals(params.get("workdir"));
        String repo = (String)params.get("repo");
        byte[] content = null;
        if (params.get("content") instanceof String) {
            content = ((String)params.get("content")).getBytes(StandardCharsets.UTF_8);
        } else if (params.get("content") instanceof byte[]) {
            content = (byte[])params.get("content");
        } else {
            throw new WarpScriptException(this.getName() + " can only store content of type STRING or BYTES, specified under key '" + "content" + "'.");
        }
        if (null == GitWarpScriptExtension.getRoot()) {
            throw new WarpScriptException(this.getName() + " Git root was not configured.");
        }
        Map capabilities = Capabilities.get((WarpScriptStack)stack, (List)null);
        if (!repo.equals(capabilities.get("git.repo"))) {
            throw new WarpScriptException(this.getName() + " missing or invalid '" + "git.repo" + "' capability.");
        }
        if (null != capabilities.get("git.ro")) {
            throw new WarpScriptException(this.getName() + " no right to modify repository '" + repo + "'.");
        }
        if (null != capabilities.get("git.subdir")) {
            path = (String)capabilities.get("git.subdir") + "/" + path;
        }
        if (path.contains("/../") || path.contains("/./") || path.startsWith("./") || path.startsWith("../") || path.startsWith("/")) {
            throw new WarpScriptException(this.getName() + " invalid path.");
        }
        File repodir = new File(GitWarpScriptExtension.getRoot(), repo);
        File target = new File(repodir, path);
        Git git = null;
        try {
            git = Git.open((File)new File(GitWarpScriptExtension.getRoot(), repo));
            if (!target.exists()) {
                try {
                    FileUtils.forceMkdir((File)target.getParentFile());
                }
                catch (IOException ioe) {
                    throw new WarpScriptException(this.getName() + " error creating path.", (Throwable)ioe);
                }
            } else if (target.exists() && target.isDirectory()) {
                throw new WarpScriptException(this.getName() + " path points to a directory.");
            }
            try {
                FileUtils.writeByteArrayToFile((File)target, (byte[])content);
            }
            catch (IOException ioe) {
                throw new WarpScriptException(this.getName() + " error writing file content.", (Throwable)ioe);
            }
            AddCommand add = git.add();
            add.addFilepattern(path);
            add.call();
            CommitCommand commit = git.commit();
            commit.setAuthor(capabilities.getOrDefault("git.name", "warp10-ext-git"), capabilities.getOrDefault("git.email", "contact@senx.io"));
            commit.setAllowEmpty(false);
            commit.setCommitter("warp10-ext-git", "contact@senx.io");
            commit.setMessage(message);
            RevCommit rev = commit.call();
            if (noworkdir) {
                org.eclipse.jgit.util.FileUtils.delete((File)target, (int)8);
            }
            stack.push((Object)rev.getId().name());
        }
        catch (EmptyCommitException ece) {
            stack.push(null);
        }
        catch (Exception e) {
            throw new WarpScriptException(this.getName() + " error opening Git repository '" + repo + "'.");
        }
        finally {
            if (null != git) {
                git.close();
            }
        }
        return stack;
    }
}

