/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.ext.git;

import io.warp10.ext.git.GitWarpScriptExtension;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import io.warp10.warp.sdk.Capabilities;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.jgit.api.CommitCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.RmCommand;
import org.eclipse.jgit.revwalk.RevCommit;

public class GITRM
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    public GITRM(String name) {
        super(name);
    }

    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object top = stack.pop();
        if (!(top instanceof Map)) {
            throw new WarpScriptException(this.getName() + " expects a parameter MAP.");
        }
        Map params = (Map)top;
        ArrayList<String> pathes = new ArrayList<String>();
        if (params.get("path") instanceof String) {
            pathes.add((String)params.get("path"));
        } else if (params.get("path") instanceof List) {
            for (Object elt : (List)params.get("path")) {
                if (!(elt instanceof String)) {
                    throw new WarpScriptException(this.getName() + " key '" + "path" + "' should point to a path or a list thereof.");
                }
                pathes.add((String)elt);
            }
        } else {
            throw new WarpScriptException(this.getName() + " key '" + "path" + "' should point to a path or a list thereof.");
        }
        if (!(params.get("repo") instanceof String)) {
            throw new WarpScriptException(this.getName() + " unset repository under key '" + "repo" + "'.");
        }
        String repo = (String)params.get("repo");
        if (!(params.get("message") instanceof String)) {
            throw new WarpScriptException(this.getName() + " expects a commit message under key '" + "message" + "'.");
        }
        String message = (String)params.get("message");
        if (null == GitWarpScriptExtension.getRoot()) {
            throw new WarpScriptException(this.getName() + " Git root was not configured.");
        }
        Map capabilities = Capabilities.get((WarpScriptStack)stack, (List)null);
        if (!repo.equals(capabilities.get("git.repo"))) {
            throw new WarpScriptException(this.getName() + " missing or invalid '" + "git.repo" + "' capability.");
        }
        if (null != capabilities.get("git.ro")) {
            throw new WarpScriptException(this.getName() + " no right to modify repository '" + repo + "'.");
        }
        String subdir = (String)capabilities.get("git.subdir");
        Git git = null;
        try {
            git = Git.open((File)new File(GitWarpScriptExtension.getRoot(), repo));
            RmCommand rm = git.rm();
            for (String path : pathes) {
                if (null == subdir) {
                    rm.addFilepattern(path);
                    continue;
                }
                rm.addFilepattern(subdir + "/" + path);
            }
            rm.call();
            CommitCommand commit = git.commit();
            commit.setAuthor(capabilities.getOrDefault("git.name", "warp10-ext-git"), capabilities.getOrDefault("git.email", "contact@senx.io"));
            commit.setAllowEmpty(false);
            commit.setCommitter("warp10-ext-git", "contact@senx.io");
            commit.setMessage(message);
            RevCommit rev = commit.call();
            stack.push((Object)rev.getId().name());
        }
        catch (Exception e) {
            throw new WarpScriptException(this.getName() + " error opening Git repository '" + repo + "'.");
        }
        finally {
            if (null != git) {
                git.close();
            }
        }
        return stack;
    }
}

