/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.ext.git;

import io.warp10.ext.git.GITFIND;
import io.warp10.ext.git.GitWarpScriptExtension;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import io.warp10.warp.sdk.Capabilities;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.LogCommand;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevTag;
import org.eclipse.jgit.revwalk.RevWalk;

public class GITLOG
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    private static final GITFIND GITFIND = new GITFIND("GITFIND");

    public GITLOG(String name) {
        super(name);
    }

    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object top = stack.pop();
        if (!(top instanceof Map)) {
            throw new WarpScriptException(this.getName() + " expects a parameter MAP.");
        }
        Map params = (Map)top;
        ArrayList<String> pathes = new ArrayList<String>();
        if (params.get("path") instanceof String) {
            pathes.add((String)params.get("path"));
        } else if (params.get("path") instanceof List) {
            for (Object elt : (List)params.get("path")) {
                if (!(elt instanceof String)) {
                    throw new WarpScriptException(this.getName() + " key '" + "path" + "' should point to a path or a list thereof.");
                }
                pathes.add((String)elt);
            }
        }
        if (pathes.contains("")) {
            pathes.remove("");
        }
        Integer count = null;
        Integer skip = null;
        if (params.get("count") instanceof Long && (count = Integer.valueOf(Math.toIntExact((Long)params.get("count")))) < 0) {
            count = 0;
        }
        if (params.get("skip") instanceof Long && (skip = Integer.valueOf(Math.toIntExact((Long)params.get("skip")))) < 0) {
            skip = null;
        }
        if (!(params.get("repo") instanceof String)) {
            throw new WarpScriptException(this.getName() + " unset repository under key '" + "repo" + "'.");
        }
        String repo = (String)params.get("repo");
        if (null == GitWarpScriptExtension.getRoot()) {
            throw new WarpScriptException(this.getName() + " Git root was not configured.");
        }
        Map capabilities = Capabilities.get((WarpScriptStack)stack, (List)null);
        if (!repo.equals(capabilities.get("git.repo"))) {
            throw new WarpScriptException(this.getName() + " missing or invalid '" + "git.repo" + "' capability.");
        }
        String subdir = (String)capabilities.get("git.subdir");
        if (pathes.isEmpty()) {
            stack.push((Object)params);
            GITFIND.apply(stack);
            List l = (List)stack.pop();
            for (Object o : l) {
                pathes.add(String.valueOf(o));
            }
        }
        Git git = null;
        try {
            git = Git.open((File)new File(GitWarpScriptExtension.getRoot(), repo));
            LinkedHashMap<String, Map<Object, Object>> revs = new LinkedHashMap<String, Map<Object, Object>>();
            LogCommand log = git.log();
            if (null != count) {
                log = log.setMaxCount(count.intValue());
            }
            if (null != skip) {
                log = log.setSkip(skip.intValue());
            }
            for (String string : pathes) {
                if (null == subdir) {
                    log.addPath(string);
                    continue;
                }
                log.addPath(subdir + "/" + string);
            }
            Iterable commits = log.call();
            for (RevCommit commit : commits) {
                LinkedHashMap<String, Object> infos = new LinkedHashMap<String, Object>();
                infos.put("rev", commit.getName());
                infos.put("message", commit.getFullMessage());
                infos.put("type", Constants.typeString((int)commit.getType()));
                PersonIdent person = commit.getAuthorIdent();
                infos.put("author.name", person.getName());
                infos.put("author.email", person.getEmailAddress());
                infos.put("author.timestamp", person.getWhen().getTime() * io.warp10.continuum.store.Constants.TIME_UNITS_PER_MS);
                person = commit.getCommitterIdent();
                infos.put("committer.name", person.getName());
                infos.put("committer.email", person.getEmailAddress());
                infos.put("committer.timestamp", person.getWhen().getTime() * io.warp10.continuum.store.Constants.TIME_UNITS_PER_MS);
                revs.put(commit.getName(), infos);
            }
            List list = git.tagList().call();
            RevWalk walk = new RevWalk(git.getRepository());
            for (Ref ref : list) {
                PersonIdent person;
                Map<String, ArrayList<String>> infos;
                RevObject rev = walk.parseAny((AnyObjectId)ref.getObjectId());
                if (rev instanceof RevTag) {
                    RevTag rt = (RevTag)rev;
                    infos = new LinkedHashMap<String, Object>();
                    infos.put("rev", (ArrayList<String>)((Object)rt.getName()));
                    infos.put("message", (ArrayList<String>)((Object)rt.getFullMessage()));
                    infos.put("type", (ArrayList<String>)((Object)Constants.typeString((int)rt.getType())));
                    infos.put("tag", (ArrayList<String>)((Object)rt.getTagName()));
                    infos.put("tagged", (ArrayList<String>)((Object)rt.getObject().getName()));
                    person = rt.getTaggerIdent();
                    infos.put("author.name", (ArrayList<String>)((Object)person.getName()));
                    infos.put("author.email", (ArrayList<String>)((Object)person.getEmailAddress()));
                    infos.put("author.timestamp", (ArrayList<String>)(person.getWhen().getTime() * io.warp10.continuum.store.Constants.TIME_UNITS_PER_MS));
                    if (!revs.containsKey(rt.getObject().getName())) continue;
                    revs.put(rt.getName(), infos);
                    infos = (Map)revs.get(rt.getObject().getName());
                    ArrayList<String> tags = (ArrayList<String>)infos.get("tags");
                    if (null == tags) {
                        tags = new ArrayList<String>();
                        infos.put("tags", tags);
                    }
                    tags.add(rt.getTagName());
                    continue;
                }
                if (rev instanceof RevCommit) {
                    RevCommit commit = (RevCommit)rev;
                    infos = new LinkedHashMap();
                    infos.put("rev", (ArrayList<String>)((Object)commit.getName()));
                    infos.put("message", (ArrayList<String>)((Object)commit.getFullMessage()));
                    infos.put("type", (ArrayList<String>)((Object)Constants.typeString((int)commit.getType())));
                    person = commit.getAuthorIdent();
                    infos.put("author.name", (ArrayList<String>)((Object)person.getName()));
                    infos.put("author.email", (ArrayList<String>)((Object)person.getEmailAddress()));
                    infos.put("author.timestamp", (ArrayList<String>)(person.getWhen().getTime() * io.warp10.continuum.store.Constants.TIME_UNITS_PER_MS));
                    person = commit.getCommitterIdent();
                    infos.put("committer.name", (ArrayList<String>)((Object)person.getName()));
                    infos.put("committer.email", (ArrayList<String>)((Object)person.getEmailAddress()));
                    infos.put("committer.timestamp", (ArrayList<String>)(person.getWhen().getTime() * io.warp10.continuum.store.Constants.TIME_UNITS_PER_MS));
                    revs.putIfAbsent(commit.getName(), infos);
                    continue;
                }
                throw new WarpScriptException(this.getName() + " encountered an invalid tag reference.");
            }
            stack.push(new ArrayList(revs.values()));
        }
        catch (Exception e) {
            throw new WarpScriptException(this.getName() + " error opening Git repository '" + repo + "'.");
        }
        finally {
            if (null != git) {
                git.close();
            }
        }
        return stack;
    }
}

