/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.ext.git;

import io.warp10.ext.git.GitWarpScriptExtension;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import io.warp10.warp.sdk.Capabilities;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;

public class GITLOAD
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    public GITLOAD(String name) {
        super(name);
    }

    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object top = stack.pop();
        if (!(top instanceof Map)) {
            throw new WarpScriptException(this.getName() + " expects a parameter MAP.");
        }
        Map params = (Map)top;
        if (!(params.get("path") instanceof String)) {
            throw new WarpScriptException(this.getName() + " unset path under key '" + "path" + "'.");
        }
        String path = (String)params.get("path");
        if (!(params.get("repo") instanceof String)) {
            throw new WarpScriptException(this.getName() + " unset repository under key '" + "repo" + "'.");
        }
        String repo = (String)params.get("repo");
        String rev = "HEAD";
        if (params.get("rev") instanceof String) {
            rev = (String)params.get("rev");
        }
        if (null == GitWarpScriptExtension.getRoot()) {
            throw new WarpScriptException(this.getName() + " Git root was not configured.");
        }
        Map capabilities = Capabilities.get((WarpScriptStack)stack, (List)null);
        if (!repo.equals(capabilities.get("git.repo"))) {
            throw new WarpScriptException(this.getName() + " missing or invalid '" + "git.repo" + "' capability.");
        }
        String rawpath = path;
        if (null != capabilities.get("git.subdir")) {
            path = (String)capabilities.get("git.subdir") + "/" + path;
        }
        if (path.contains("/../") || path.contains("/./") || path.startsWith("./") || path.startsWith("../")) {
            throw new WarpScriptException(this.getName() + " invalid path.");
        }
        File repodir = new File(GitWarpScriptExtension.getRoot(), repo);
        File target = new File(repodir, path);
        Git git = null;
        try {
            git = Git.open((File)new File(GitWarpScriptExtension.getRoot(), repo));
            ObjectId lastCommitId = git.getRepository().resolve(rev);
            if (null == lastCommitId) {
                throw new WarpScriptException(this.getName() + " revision '" + rev + "' was not found in repository '" + repo + "'.");
            }
            RevWalk rwalk = new RevWalk(git.getRepository());
            RevCommit commit = rwalk.parseCommit((AnyObjectId)lastCommitId);
            RevTree tree = commit.getTree();
            TreeWalk twalk = new TreeWalk(git.getRepository());
            twalk.addTree((AnyObjectId)tree);
            twalk.setRecursive(true);
            twalk.setFilter((TreeFilter)PathFilter.create((String)path));
            if (twalk.next()) {
                ObjectId objectId = twalk.getObjectId(0);
                ObjectLoader loader = git.getRepository().open((AnyObjectId)objectId);
                stack.push((Object)loader.getBytes());
            } else {
                stack.push(null);
            }
            twalk.close();
            rwalk.dispose();
        }
        catch (Exception e) {
            throw new WarpScriptException(this.getName() + " error opening Git repository '" + repo + "'.");
        }
        finally {
            if (null != git) {
                git.close();
            }
        }
        return stack;
    }
}

