/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.ext.git;

import io.warp10.ext.git.GitWarpScriptExtension;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import io.warp10.warp.sdk.Capabilities;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.TreeFilter;

public class GITFIND
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    public GITFIND(String name) {
        super(name);
    }

    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object top = stack.pop();
        if (!(top instanceof Map)) {
            throw new WarpScriptException(this.getName() + " expects a parameter MAP.");
        }
        Map params = (Map)top;
        if (null != params.get("regexp") && !(params.get("regexp") instanceof String)) {
            throw new WarpScriptException(this.getName() + " unset filter predicate under key '" + "regexp" + "'.");
        }
        String filter = (String)params.get("regexp");
        if (!(params.get("repo") instanceof String)) {
            throw new WarpScriptException(this.getName() + " unset repository under key '" + "repo" + "'.");
        }
        String repo = (String)params.get("repo");
        if (null == GitWarpScriptExtension.getRoot()) {
            throw new WarpScriptException(this.getName() + " Git root was not configured.");
        }
        Map capabilities = Capabilities.get((WarpScriptStack)stack, (List)null);
        if (!repo.equals(capabilities.get("git.repo"))) {
            throw new WarpScriptException(this.getName() + " missing or invalid '" + "git.repo" + "' capability.");
        }
        String subdir = (String)capabilities.get("git.subdir");
        if (null != subdir) {
            filter = null == filter ? subdir + "/.*" : (filter.startsWith("^") ? "^" + Pattern.quote(subdir) + "/" + filter.substring(1) : Pattern.quote(subdir) + "/" + filter);
        }
        Git git = null;
        final String ffilter = filter;
        try {
            git = Git.open((File)new File(GitWarpScriptExtension.getRoot(), repo));
            ObjectId lastCommitId = git.getRepository().resolve("HEAD");
            ArrayList<String> entries = new ArrayList<String>();
            RevWalk rwalk = new RevWalk(git.getRepository());
            RevCommit commit = rwalk.parseCommit((AnyObjectId)lastCommitId);
            RevTree tree = commit.getTree();
            TreeWalk twalk = new TreeWalk(git.getRepository());
            twalk.addTree((AnyObjectId)tree);
            twalk.setRecursive(true);
            twalk.setFilter(null == ffilter ? TreeFilter.ALL : new TreeFilter(){
                Matcher matcher;
                {
                    this.matcher = Pattern.compile(ffilter).matcher("");
                }

                public boolean shouldBeRecursive() {
                    return true;
                }

                public boolean include(TreeWalk walker) throws MissingObjectException, IncorrectObjectTypeException, IOException {
                    if (walker.getRawPath()[walker.getPathLength() - 1] == 47) {
                        return true;
                    }
                    if (walker.isSubtree()) {
                        return true;
                    }
                    String path = walker.getPathString();
                    return this.matcher.reset(path).matches();
                }

                public TreeFilter clone() {
                    return null;
                }
            });
            while (twalk.next()) {
                if (null != subdir) {
                    entries.add(twalk.getPathString().substring(subdir.length() + 1));
                    continue;
                }
                entries.add(twalk.getPathString());
            }
            twalk.close();
            rwalk.dispose();
            stack.push(entries);
        }
        catch (Exception e) {
            throw new WarpScriptException(this.getName() + " error opening Git repository.", (Throwable)e);
        }
        finally {
            if (null != git) {
                git.close();
            }
        }
        return stack;
    }
}

