/*
 * Decompiled with CFR 0.152.
 */
package io.voucherify.client.model.product;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Product {
    private String id;
    private String name;
    private Integer price;
    @JsonProperty(value="source_id")
    private String sourceId;
    private List<String> attributes;
    private Map<String, Object> metadata;

    public static ProductBuilder builder() {
        return new ProductBuilder();
    }

    private Product() {
    }

    private Product(String id, String name, Integer price, String sourceId, List<String> attributes, Map<String, Object> metadata) {
        this.id = id;
        this.name = name;
        this.price = price;
        this.sourceId = sourceId;
        this.attributes = attributes;
        this.metadata = metadata;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Integer getPrice() {
        return this.price;
    }

    public String getSourceId() {
        return this.sourceId;
    }

    public List<String> getAttributes() {
        return this.attributes;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public String toString() {
        return "Product(id=" + this.getId() + ", name=" + this.getName() + ", price=" + this.getPrice() + ", sourceId=" + this.getSourceId() + ", attributes=" + this.getAttributes() + ", metadata=" + this.getMetadata() + ")";
    }

    public static class ProductBuilder {
        private String id;
        private String name;
        private Integer price;
        private String sourceId;
        private ArrayList<String> attributes;
        private ArrayList<String> metadata$key;
        private ArrayList<Object> metadata$value;

        ProductBuilder() {
        }

        public ProductBuilder id(String id) {
            this.id = id;
            return this;
        }

        public ProductBuilder name(String name) {
            this.name = name;
            return this;
        }

        public ProductBuilder price(Integer price) {
            this.price = price;
            return this;
        }

        @JsonProperty(value="source_id")
        public ProductBuilder sourceId(String sourceId) {
            this.sourceId = sourceId;
            return this;
        }

        public ProductBuilder attribute(String attribute) {
            if (this.attributes == null) {
                this.attributes = new ArrayList();
            }
            this.attributes.add(attribute);
            return this;
        }

        public ProductBuilder attributes(Collection<? extends String> attributes) {
            if (this.attributes == null) {
                this.attributes = new ArrayList();
            }
            this.attributes.addAll(attributes);
            return this;
        }

        public ProductBuilder clearAttributes() {
            if (this.attributes != null) {
                this.attributes.clear();
            }
            return this;
        }

        public ProductBuilder metadataEntry(String metadataEntryKey, Object metadataEntryValue) {
            if (this.metadata$key == null) {
                this.metadata$key = new ArrayList();
                this.metadata$value = new ArrayList();
            }
            this.metadata$key.add(metadataEntryKey);
            this.metadata$value.add(metadataEntryValue);
            return this;
        }

        public ProductBuilder metadata(Map<? extends String, ? extends Object> metadata) {
            if (this.metadata$key == null) {
                this.metadata$key = new ArrayList();
                this.metadata$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends Object> $lombokEntry : metadata.entrySet()) {
                this.metadata$key.add($lombokEntry.getKey());
                this.metadata$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public ProductBuilder clearMetadata() {
            if (this.metadata$key != null) {
                this.metadata$key.clear();
                this.metadata$value.clear();
            }
            return this;
        }

        public Product build() {
            Map<Object, Object> metadata;
            List<Object> attributes;
            switch (this.attributes == null ? 0 : this.attributes.size()) {
                case 0: {
                    attributes = Collections.emptyList();
                    break;
                }
                case 1: {
                    attributes = Collections.singletonList(this.attributes.get(0));
                    break;
                }
                default: {
                    attributes = Collections.unmodifiableList(new ArrayList<String>(this.attributes));
                }
            }
            switch (this.metadata$key == null ? 0 : this.metadata$key.size()) {
                case 0: {
                    metadata = Collections.emptyMap();
                    break;
                }
                case 1: {
                    metadata = Collections.singletonMap(this.metadata$key.get(0), this.metadata$value.get(0));
                    break;
                }
                default: {
                    metadata = new LinkedHashMap(this.metadata$key.size() < 0x40000000 ? 1 + this.metadata$key.size() + (this.metadata$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.metadata$key.size(); ++$i) {
                        metadata.put(this.metadata$key.get($i), this.metadata$value.get($i));
                    }
                    metadata = Collections.unmodifiableMap(metadata);
                }
            }
            return new Product(this.id, this.name, this.price, this.sourceId, attributes, metadata);
        }

        public String toString() {
            return "Product.ProductBuilder(id=" + this.id + ", name=" + this.name + ", price=" + this.price + ", sourceId=" + this.sourceId + ", attributes=" + this.attributes + ", metadata$key=" + this.metadata$key + ", metadata$value=" + this.metadata$value + ")";
        }
    }
}

