/*
 * Decompiled with CFR 0.152.
 */
package io.voucherify.example.sync;

import io.voucherify.client.VoucherifyClient;
import io.voucherify.client.model.product.DeleteProductParams;
import io.voucherify.client.model.product.DeleteSKUParams;
import io.voucherify.client.model.product.Product;
import io.voucherify.client.model.product.ProductsFilter;
import io.voucherify.client.model.product.SKU;
import io.voucherify.client.model.product.response.ProductResponse;
import io.voucherify.client.model.product.response.SKUResponse;
import io.voucherify.example.sync.AbsExample;

public class ProductsExample
extends AbsExample {
    public ProductsExample(VoucherifyClient client) {
        super(client);
    }

    @Override
    public void example() {
        Product product = Product.builder().name("product").attribute("attribute1").attribute("attribute2").metadataEntry("key_1", "value_1").metadataEntry("key_2", "value_2").build();
        ProductResponse result = this.client.products().create(product);
        this.client.products().get(result.getId());
        Product update = Product.builder().id(result.getId()).sourceId("sourceId").build();
        this.client.products().update(update);
        this.client.products().list(ProductsFilter.builder().limit(10).page(0).build());
        SKU sku = SKU.builder().sku("sku").attribute("key_1", "value_1").metadataEntry("key_1", "value_1").build();
        SKUResponse skuResult = this.client.products().createSKU(result.getId(), sku);
        this.client.products().getSKU(result.getId(), skuResult.getId());
        SKU skuUpdate = SKU.builder().id(skuResult.getId()).sourceId("sourceId").build();
        this.client.products().updateSKU(result.getId(), skuUpdate);
        System.out.println(this.client.products().listSKU(result.getId()));
        this.client.products().deleteSKU(result.getId(), skuResult.getId(), DeleteSKUParams.builder().force(true).build());
        this.client.products().delete(result.getId(), DeleteProductParams.builder().force(true).build());
    }
}

