/*
 * Decompiled with CFR 0.152.
 */
package io.voucherify.client.model.customer;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.voucherify.client.model.customer.Address;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class Customer {
    private String id;
    @JsonProperty(value="source_id")
    private String sourceId;
    private String name;
    private String email;
    private String description;
    private Address address;
    private String phone;
    private Map<String, Object> metadata;

    public static CustomerBuilder builder() {
        return new CustomerBuilder();
    }

    private Customer() {
    }

    private Customer(String id, String sourceId, String name, String email, String description, Address address, String phone, Map<String, Object> metadata) {
        this.id = id;
        this.sourceId = sourceId;
        this.name = name;
        this.email = email;
        this.description = description;
        this.address = address;
        this.phone = phone;
        this.metadata = metadata;
    }

    public String getId() {
        return this.id;
    }

    public String getSourceId() {
        return this.sourceId;
    }

    public String getName() {
        return this.name;
    }

    public String getEmail() {
        return this.email;
    }

    public String getDescription() {
        return this.description;
    }

    public Address getAddress() {
        return this.address;
    }

    public String getPhone() {
        return this.phone;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public String toString() {
        return "Customer(id=" + this.getId() + ", sourceId=" + this.getSourceId() + ", name=" + this.getName() + ", email=" + this.getEmail() + ", description=" + this.getDescription() + ", address=" + this.getAddress() + ", phone=" + this.getPhone() + ", metadata=" + this.getMetadata() + ")";
    }

    public static class CustomerBuilder {
        private String id;
        private String sourceId;
        private String name;
        private String email;
        private String description;
        private Address address;
        private String phone;
        private ArrayList<String> metadata$key;
        private ArrayList<Object> metadata$value;

        CustomerBuilder() {
        }

        public CustomerBuilder id(String id) {
            this.id = id;
            return this;
        }

        @JsonProperty(value="source_id")
        public CustomerBuilder sourceId(String sourceId) {
            this.sourceId = sourceId;
            return this;
        }

        public CustomerBuilder name(String name) {
            this.name = name;
            return this;
        }

        public CustomerBuilder email(String email) {
            this.email = email;
            return this;
        }

        public CustomerBuilder description(String description) {
            this.description = description;
            return this;
        }

        public CustomerBuilder address(Address address) {
            this.address = address;
            return this;
        }

        public CustomerBuilder phone(String phone) {
            this.phone = phone;
            return this;
        }

        public CustomerBuilder metadataEntry(String metadataEntryKey, Object metadataEntryValue) {
            if (this.metadata$key == null) {
                this.metadata$key = new ArrayList();
                this.metadata$value = new ArrayList();
            }
            this.metadata$key.add(metadataEntryKey);
            this.metadata$value.add(metadataEntryValue);
            return this;
        }

        public CustomerBuilder metadata(Map<? extends String, ? extends Object> metadata) {
            if (this.metadata$key == null) {
                this.metadata$key = new ArrayList();
                this.metadata$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends Object> $lombokEntry : metadata.entrySet()) {
                this.metadata$key.add($lombokEntry.getKey());
                this.metadata$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public CustomerBuilder clearMetadata() {
            if (this.metadata$key != null) {
                this.metadata$key.clear();
                this.metadata$value.clear();
            }
            return this;
        }

        public Customer build() {
            Map<Object, Object> metadata;
            switch (this.metadata$key == null ? 0 : this.metadata$key.size()) {
                case 0: {
                    metadata = Collections.emptyMap();
                    break;
                }
                case 1: {
                    metadata = Collections.singletonMap(this.metadata$key.get(0), this.metadata$value.get(0));
                    break;
                }
                default: {
                    metadata = new LinkedHashMap(this.metadata$key.size() < 0x40000000 ? 1 + this.metadata$key.size() + (this.metadata$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.metadata$key.size(); ++$i) {
                        metadata.put(this.metadata$key.get($i), this.metadata$value.get($i));
                    }
                    metadata = Collections.unmodifiableMap(metadata);
                }
            }
            return new Customer(this.id, this.sourceId, this.name, this.email, this.description, this.address, this.phone, metadata);
        }

        public String toString() {
            return "Customer.CustomerBuilder(id=" + this.id + ", sourceId=" + this.sourceId + ", name=" + this.name + ", email=" + this.email + ", description=" + this.description + ", address=" + this.address + ", phone=" + this.phone + ", metadata$key=" + this.metadata$key + ", metadata$value=" + this.metadata$value + ")";
        }
    }
}

