/*
 * Decompiled with CFR 0.152.
 */
package io.voucherify.client.model;

import io.voucherify.client.model.QualificationOrder;
import io.voucherify.client.utils.AbstractFilter;
import java.util.HashMap;
import java.util.Map;

public class QualifiedResourceFilter
extends AbstractFilter<String, Object> {
    private Integer limit;
    private Boolean audienceRulesOnly;
    private QualificationOrder qualificationOrder;

    @Override
    public Map<String, Object> getMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("limit", this.limit);
        map.put("audienceRulesOnly", this.audienceRulesOnly);
        if (this.qualificationOrder != null) {
            map.put("order", this.qualificationOrder.asQueryParam());
        }
        return map;
    }

    public static QualifiedResourceFilterBuilder builder() {
        return new QualifiedResourceFilterBuilder();
    }

    private QualifiedResourceFilter() {
    }

    private QualifiedResourceFilter(Integer limit, Boolean audienceRulesOnly, QualificationOrder qualificationOrder) {
        this.limit = limit;
        this.audienceRulesOnly = audienceRulesOnly;
        this.qualificationOrder = qualificationOrder;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public Boolean getAudienceRulesOnly() {
        return this.audienceRulesOnly;
    }

    public QualificationOrder getQualificationOrder() {
        return this.qualificationOrder;
    }

    public String toString() {
        return "QualifiedResourceFilter(limit=" + this.getLimit() + ", audienceRulesOnly=" + this.getAudienceRulesOnly() + ", qualificationOrder=" + this.getQualificationOrder() + ")";
    }

    public static class QualifiedResourceFilterBuilder {
        private Integer limit;
        private Boolean audienceRulesOnly;
        private QualificationOrder qualificationOrder;

        QualifiedResourceFilterBuilder() {
        }

        public QualifiedResourceFilterBuilder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public QualifiedResourceFilterBuilder audienceRulesOnly(Boolean audienceRulesOnly) {
            this.audienceRulesOnly = audienceRulesOnly;
            return this;
        }

        public QualifiedResourceFilterBuilder qualificationOrder(QualificationOrder qualificationOrder) {
            this.qualificationOrder = qualificationOrder;
            return this;
        }

        public QualifiedResourceFilter build() {
            return new QualifiedResourceFilter(this.limit, this.audienceRulesOnly, this.qualificationOrder);
        }

        public String toString() {
            return "QualifiedResourceFilter.QualifiedResourceFilterBuilder(limit=" + this.limit + ", audienceRulesOnly=" + this.audienceRulesOnly + ", qualificationOrder=" + this.qualificationOrder + ")";
        }
    }
}

