/*
 * Decompiled with CFR 0.152.
 */
package io.voucherify.client.module;

import io.voucherify.client.api.VoucherifyApi;
import io.voucherify.client.callback.VoucherifyCallback;
import io.voucherify.client.model.validationRules.BusinessValidationRuleAssignmentFilter;
import io.voucherify.client.model.validationRules.BusinessValidationRuleFilter;
import io.voucherify.client.model.validationRules.CreateBusinessValidationRule;
import io.voucherify.client.model.validationRules.CreateBusinessValidationRuleAssignment;
import io.voucherify.client.model.validationRules.UpdateBusinessValidationRule;
import io.voucherify.client.model.validationRules.response.BusinessValidationRule;
import io.voucherify.client.model.validationRules.response.BusinessValidationRuleAssignment;
import io.voucherify.client.model.validationRules.response.BusinessValidationRuleAssignmentList;
import io.voucherify.client.model.validationRules.response.BusinessValidationRuleList;
import io.voucherify.client.module.AbsModule;
import io.voucherify.client.utils.RxUtils;
import java.util.concurrent.Executor;
import rx.Observable;

public final class ValidationRulesModule
extends AbsModule<ExtAsync, ExtRxJava> {
    public ValidationRulesModule(VoucherifyApi api, Executor executor) {
        super(api, executor);
    }

    public BusinessValidationRule create(CreateBusinessValidationRule validationRule) {
        return this.api.createValidationRules(validationRule);
    }

    public BusinessValidationRule get(String id) {
        return this.api.getValidationRules(id);
    }

    public BusinessValidationRuleList list(BusinessValidationRuleFilter filter) {
        return this.api.listValidationRules(filter.asMap());
    }

    public BusinessValidationRule update(UpdateBusinessValidationRule validationRule) {
        return this.api.updateValidationRules(validationRule.getId(), validationRule);
    }

    public void delete(String id) {
        this.api.deleteValidationRules(id);
    }

    public BusinessValidationRuleAssignment createAssignment(String id, CreateBusinessValidationRuleAssignment assignment) {
        return this.api.createValidationRuleAssignment(id, assignment);
    }

    public BusinessValidationRuleAssignmentList listAssignments(String id, BusinessValidationRuleAssignmentFilter filter) {
        return this.api.listValidationRuleAssignments(id, filter.asMap());
    }

    public void deleteAssignment(String validationRuleId, String assignmentId) {
        this.api.deleteValidationRuleAssignment(validationRuleId, assignmentId);
    }

    @Override
    ExtAsync createAsyncExtension() {
        return new ExtAsync();
    }

    @Override
    ExtRxJava createRxJavaExtension() {
        return new ExtRxJava();
    }

    @Override
    public ExtAsync async() {
        return (ExtAsync)this.extAsync;
    }

    @Override
    public ExtRxJava rx() {
        return (ExtRxJava)this.extRxJava;
    }

    public class ExtRxJava
    extends AbsModule.Rx {
        public Observable<BusinessValidationRule> create(final CreateBusinessValidationRule validationRule) {
            return RxUtils.defer(new RxUtils.DefFunc<BusinessValidationRule>(){

                @Override
                public BusinessValidationRule method() {
                    return ValidationRulesModule.this.create(validationRule);
                }
            });
        }

        public Observable<BusinessValidationRule> get(final String id) {
            return RxUtils.defer(new RxUtils.DefFunc<BusinessValidationRule>(){

                @Override
                public BusinessValidationRule method() {
                    return ValidationRulesModule.this.get(id);
                }
            });
        }

        public Observable<BusinessValidationRuleList> list(final BusinessValidationRuleFilter filter) {
            return RxUtils.defer(new RxUtils.DefFunc<BusinessValidationRuleList>(){

                @Override
                public BusinessValidationRuleList method() {
                    return ValidationRulesModule.this.list(filter);
                }
            });
        }

        public Observable<BusinessValidationRule> update(final UpdateBusinessValidationRule validationRule) {
            return RxUtils.defer(new RxUtils.DefFunc<BusinessValidationRule>(){

                @Override
                public BusinessValidationRule method() {
                    return ValidationRulesModule.this.update(validationRule);
                }
            });
        }

        public Observable<Void> delete(final String id) {
            return RxUtils.defer(new RxUtils.DefFunc<Void>(){

                @Override
                public Void method() {
                    ValidationRulesModule.this.delete(id);
                    return null;
                }
            });
        }

        public Observable<BusinessValidationRuleAssignment> createAssignment(final String id, final CreateBusinessValidationRuleAssignment assignment) {
            return RxUtils.defer(new RxUtils.DefFunc<BusinessValidationRuleAssignment>(){

                @Override
                public BusinessValidationRuleAssignment method() {
                    return ValidationRulesModule.this.createAssignment(id, assignment);
                }
            });
        }

        public Observable<BusinessValidationRuleAssignmentList> listAssignments(final String id, final BusinessValidationRuleAssignmentFilter filter) {
            return RxUtils.defer(new RxUtils.DefFunc<BusinessValidationRuleAssignmentList>(){

                @Override
                public BusinessValidationRuleAssignmentList method() {
                    return ValidationRulesModule.this.listAssignments(id, filter);
                }
            });
        }

        public Observable<Void> deleteAssignment(final String validationRuleId, final String assignmentId) {
            return RxUtils.defer(new RxUtils.DefFunc<Void>(){

                @Override
                public Void method() {
                    ValidationRulesModule.this.deleteAssignment(validationRuleId, assignmentId);
                    return null;
                }
            });
        }
    }

    public class ExtAsync
    extends AbsModule.Async {
        public void create(CreateBusinessValidationRule validationRule, VoucherifyCallback<BusinessValidationRule> callback) {
            RxUtils.subscribe(ValidationRulesModule.this.executor, ValidationRulesModule.this.rx().create(validationRule), callback);
        }

        public void get(String id, VoucherifyCallback<BusinessValidationRule> callback) {
            RxUtils.subscribe(ValidationRulesModule.this.executor, ValidationRulesModule.this.rx().get(id), callback);
        }

        public void update(UpdateBusinessValidationRule validationRule, VoucherifyCallback<BusinessValidationRule> callback) {
            RxUtils.subscribe(ValidationRulesModule.this.executor, ValidationRulesModule.this.rx().update(validationRule), callback);
        }

        public void delete(String id, VoucherifyCallback<Void> callback) {
            RxUtils.subscribe(ValidationRulesModule.this.executor, ValidationRulesModule.this.rx().delete(id), callback);
        }

        public void list(BusinessValidationRuleFilter filter, VoucherifyCallback<BusinessValidationRuleList> callback) {
            RxUtils.subscribe(ValidationRulesModule.this.executor, ValidationRulesModule.this.rx().list(filter), callback);
        }

        public void createAssignment(String id, CreateBusinessValidationRuleAssignment assignment, VoucherifyCallback<BusinessValidationRuleAssignment> callback) {
            RxUtils.subscribe(ValidationRulesModule.this.executor, ValidationRulesModule.this.rx().createAssignment(id, assignment), callback);
        }

        public void deleteAssignment(String validationRuleId, String assignmentId, VoucherifyCallback<Void> callback) {
            RxUtils.subscribe(ValidationRulesModule.this.executor, ValidationRulesModule.this.rx().deleteAssignment(validationRuleId, assignmentId), callback);
        }

        public void listAssignments(String id, BusinessValidationRuleAssignmentFilter filter, VoucherifyCallback<BusinessValidationRuleAssignmentList> callback) {
            RxUtils.subscribe(ValidationRulesModule.this.executor, ValidationRulesModule.this.rx().listAssignments(id, filter), callback);
        }
    }
}

