/*
 * Decompiled with CFR 0.152.
 */
package io.voucherify.client.model.voucher;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.voucherify.client.json.serializer.ImportVouchersSerializer;
import io.voucherify.client.model.voucher.Voucher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

@JsonSerialize(using=ImportVouchersSerializer.class)
public class ImportVouchers {
    private List<Voucher> vouchers;

    public static ImportVouchersBuilder builder() {
        return new ImportVouchersBuilder();
    }

    private ImportVouchers() {
    }

    private ImportVouchers(List<Voucher> vouchers) {
        this.vouchers = vouchers;
    }

    public List<Voucher> getVouchers() {
        return this.vouchers;
    }

    public String toString() {
        return "ImportVouchers(vouchers=" + this.getVouchers() + ")";
    }

    public static class ImportVouchersBuilder {
        private ArrayList<Voucher> vouchers;

        ImportVouchersBuilder() {
        }

        public ImportVouchersBuilder voucher(Voucher voucher) {
            if (this.vouchers == null) {
                this.vouchers = new ArrayList();
            }
            this.vouchers.add(voucher);
            return this;
        }

        public ImportVouchersBuilder vouchers(Collection<? extends Voucher> vouchers) {
            if (this.vouchers == null) {
                this.vouchers = new ArrayList();
            }
            this.vouchers.addAll(vouchers);
            return this;
        }

        public ImportVouchersBuilder clearVouchers() {
            if (this.vouchers != null) {
                this.vouchers.clear();
            }
            return this;
        }

        public ImportVouchers build() {
            List<Object> vouchers;
            switch (this.vouchers == null ? 0 : this.vouchers.size()) {
                case 0: {
                    vouchers = Collections.emptyList();
                    break;
                }
                case 1: {
                    vouchers = Collections.singletonList(this.vouchers.get(0));
                    break;
                }
                default: {
                    vouchers = Collections.unmodifiableList(new ArrayList<Voucher>(this.vouchers));
                }
            }
            return new ImportVouchers(vouchers);
        }

        public String toString() {
            return "ImportVouchers.ImportVouchersBuilder(vouchers=" + this.vouchers + ")";
        }
    }
}

