/*
 * Decompiled with CFR 0.152.
 */
package io.voucherify.client.model.order;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class OrderItemSKU {
    private String sku;
    @JsonProperty(value="product_id")
    private String productId;
    private Map<String, Object> metadata;
    private boolean override = false;

    public static OrderItemSKUBuilder builder() {
        return new OrderItemSKUBuilder();
    }

    private OrderItemSKU() {
    }

    private OrderItemSKU(String sku, String productId, Map<String, Object> metadata, boolean override) {
        this.sku = sku;
        this.productId = productId;
        this.metadata = metadata;
        this.override = override;
    }

    public String getSku() {
        return this.sku;
    }

    public String getProductId() {
        return this.productId;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public boolean isOverride() {
        return this.override;
    }

    public String toString() {
        return "OrderItemSKU(sku=" + this.getSku() + ", productId=" + this.getProductId() + ", metadata=" + this.getMetadata() + ", override=" + this.isOverride() + ")";
    }

    public static class OrderItemSKUBuilder {
        private String sku;
        private String productId;
        private ArrayList<String> metadata$key;
        private ArrayList<Object> metadata$value;
        private boolean override;

        OrderItemSKUBuilder() {
        }

        public OrderItemSKUBuilder sku(String sku) {
            this.sku = sku;
            return this;
        }

        public OrderItemSKUBuilder productId(String productId) {
            this.productId = productId;
            return this;
        }

        public OrderItemSKUBuilder metadataEntry(String metadataEntryKey, Object metadataEntryValue) {
            if (this.metadata$key == null) {
                this.metadata$key = new ArrayList();
                this.metadata$value = new ArrayList();
            }
            this.metadata$key.add(metadataEntryKey);
            this.metadata$value.add(metadataEntryValue);
            return this;
        }

        public OrderItemSKUBuilder metadata(Map<? extends String, ? extends Object> metadata) {
            if (this.metadata$key == null) {
                this.metadata$key = new ArrayList();
                this.metadata$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends Object> $lombokEntry : metadata.entrySet()) {
                this.metadata$key.add($lombokEntry.getKey());
                this.metadata$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public OrderItemSKUBuilder clearMetadata() {
            if (this.metadata$key != null) {
                this.metadata$key.clear();
                this.metadata$value.clear();
            }
            return this;
        }

        public OrderItemSKUBuilder override(boolean override) {
            this.override = override;
            return this;
        }

        public OrderItemSKU build() {
            Map<Object, Object> metadata;
            switch (this.metadata$key == null ? 0 : this.metadata$key.size()) {
                case 0: {
                    metadata = Collections.emptyMap();
                    break;
                }
                case 1: {
                    metadata = Collections.singletonMap(this.metadata$key.get(0), this.metadata$value.get(0));
                    break;
                }
                default: {
                    metadata = new LinkedHashMap(this.metadata$key.size() < 0x40000000 ? 1 + this.metadata$key.size() + (this.metadata$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.metadata$key.size(); ++$i) {
                        metadata.put(this.metadata$key.get($i), this.metadata$value.get($i));
                    }
                    metadata = Collections.unmodifiableMap(metadata);
                }
            }
            return new OrderItemSKU(this.sku, this.productId, metadata, this.override);
        }

        public String toString() {
            return "OrderItemSKU.OrderItemSKUBuilder(sku=" + this.sku + ", productId=" + this.productId + ", metadata$key=" + this.metadata$key + ", metadata$value=" + this.metadata$value + ", override=" + this.override + ")";
        }
    }
}

