/*
 * Decompiled with CFR 0.152.
 */
package io.voucherify.client.model.order;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.voucherify.client.model.order.OrderItemProduct;
import io.voucherify.client.model.order.OrderItemSKU;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class OrderItem {
    @JsonProperty(value="product_id")
    private String productId;
    @JsonProperty(value="sku_id")
    private String skuId;
    @JsonProperty(value="related_object")
    private String relatedObject;
    @JsonProperty(value="source_id")
    private String sourceId;
    private Integer quantity;
    private Integer amount;
    private Integer price;
    @JsonProperty(value="product")
    private OrderItemProduct orderItemProduct;
    @JsonProperty(value="sku")
    private OrderItemSKU orderItemSku;
    private Map<String, Object> metadata;

    public static OrderItemBuilder builder() {
        return new OrderItemBuilder();
    }

    private OrderItem() {
    }

    private OrderItem(String productId, String skuId, String relatedObject, String sourceId, Integer quantity, Integer amount, Integer price, OrderItemProduct orderItemProduct, OrderItemSKU orderItemSku, Map<String, Object> metadata) {
        this.productId = productId;
        this.skuId = skuId;
        this.relatedObject = relatedObject;
        this.sourceId = sourceId;
        this.quantity = quantity;
        this.amount = amount;
        this.price = price;
        this.orderItemProduct = orderItemProduct;
        this.orderItemSku = orderItemSku;
        this.metadata = metadata;
    }

    public String getProductId() {
        return this.productId;
    }

    public String getSkuId() {
        return this.skuId;
    }

    public String getRelatedObject() {
        return this.relatedObject;
    }

    public String getSourceId() {
        return this.sourceId;
    }

    public Integer getQuantity() {
        return this.quantity;
    }

    public Integer getAmount() {
        return this.amount;
    }

    public Integer getPrice() {
        return this.price;
    }

    public OrderItemProduct getOrderItemProduct() {
        return this.orderItemProduct;
    }

    public OrderItemSKU getOrderItemSku() {
        return this.orderItemSku;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public String toString() {
        return "OrderItem(productId=" + this.getProductId() + ", skuId=" + this.getSkuId() + ", relatedObject=" + this.getRelatedObject() + ", sourceId=" + this.getSourceId() + ", quantity=" + this.getQuantity() + ", amount=" + this.getAmount() + ", price=" + this.getPrice() + ", orderItemProduct=" + this.getOrderItemProduct() + ", orderItemSku=" + this.getOrderItemSku() + ", metadata=" + this.getMetadata() + ")";
    }

    public static class OrderItemBuilder {
        private String productId;
        private String skuId;
        private String relatedObject;
        private String sourceId;
        private Integer quantity;
        private Integer amount;
        private Integer price;
        private OrderItemProduct orderItemProduct;
        private OrderItemSKU orderItemSku;
        private ArrayList<String> metadata$key;
        private ArrayList<Object> metadata$value;

        OrderItemBuilder() {
        }

        public OrderItemBuilder productId(String productId) {
            this.productId = productId;
            return this;
        }

        public OrderItemBuilder skuId(String skuId) {
            this.skuId = skuId;
            return this;
        }

        public OrderItemBuilder relatedObject(String relatedObject) {
            this.relatedObject = relatedObject;
            return this;
        }

        public OrderItemBuilder sourceId(String sourceId) {
            this.sourceId = sourceId;
            return this;
        }

        public OrderItemBuilder quantity(Integer quantity) {
            this.quantity = quantity;
            return this;
        }

        public OrderItemBuilder amount(Integer amount) {
            this.amount = amount;
            return this;
        }

        public OrderItemBuilder price(Integer price) {
            this.price = price;
            return this;
        }

        public OrderItemBuilder orderItemProduct(OrderItemProduct orderItemProduct) {
            this.orderItemProduct = orderItemProduct;
            return this;
        }

        public OrderItemBuilder orderItemSku(OrderItemSKU orderItemSku) {
            this.orderItemSku = orderItemSku;
            return this;
        }

        public OrderItemBuilder metadataEntry(String metadataEntryKey, Object metadataEntryValue) {
            if (this.metadata$key == null) {
                this.metadata$key = new ArrayList();
                this.metadata$value = new ArrayList();
            }
            this.metadata$key.add(metadataEntryKey);
            this.metadata$value.add(metadataEntryValue);
            return this;
        }

        public OrderItemBuilder metadata(Map<? extends String, ? extends Object> metadata) {
            if (this.metadata$key == null) {
                this.metadata$key = new ArrayList();
                this.metadata$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends Object> $lombokEntry : metadata.entrySet()) {
                this.metadata$key.add($lombokEntry.getKey());
                this.metadata$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public OrderItemBuilder clearMetadata() {
            if (this.metadata$key != null) {
                this.metadata$key.clear();
                this.metadata$value.clear();
            }
            return this;
        }

        public OrderItem build() {
            Map<Object, Object> metadata;
            switch (this.metadata$key == null ? 0 : this.metadata$key.size()) {
                case 0: {
                    metadata = Collections.emptyMap();
                    break;
                }
                case 1: {
                    metadata = Collections.singletonMap(this.metadata$key.get(0), this.metadata$value.get(0));
                    break;
                }
                default: {
                    metadata = new LinkedHashMap(this.metadata$key.size() < 0x40000000 ? 1 + this.metadata$key.size() + (this.metadata$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.metadata$key.size(); ++$i) {
                        metadata.put(this.metadata$key.get($i), this.metadata$value.get($i));
                    }
                    metadata = Collections.unmodifiableMap(metadata);
                }
            }
            return new OrderItem(this.productId, this.skuId, this.relatedObject, this.sourceId, this.quantity, this.amount, this.price, this.orderItemProduct, this.orderItemSku, metadata);
        }

        public String toString() {
            return "OrderItem.OrderItemBuilder(productId=" + this.productId + ", skuId=" + this.skuId + ", relatedObject=" + this.relatedObject + ", sourceId=" + this.sourceId + ", quantity=" + this.quantity + ", amount=" + this.amount + ", price=" + this.price + ", orderItemProduct=" + this.orderItemProduct + ", orderItemSku=" + this.orderItemSku + ", metadata$key=" + this.metadata$key + ", metadata$value=" + this.metadata$value + ")";
        }
    }
}

