/*
 * Decompiled with CFR 0.152.
 */
package io.voucherify.client.utils;

import java.util.concurrent.Executor;
import retrofit.android.MainThreadExecutor;

public abstract class Platform {
    private static final Platform PLATFORM = Platform.findPlatform();

    public static Platform get() {
        return PLATFORM;
    }

    private static Platform findPlatform() {
        try {
            Class.forName("android.os.Build");
            return new Android();
        }
        catch (ClassNotFoundException classNotFoundException) {
            return new Base();
        }
    }

    public abstract Executor callbackExecutor();

    static class SynchronousExecutor
    implements Executor {
        SynchronousExecutor() {
        }

        @Override
        public void execute(Runnable runnable) {
            runnable.run();
        }
    }

    private static class Android
    extends Platform {
        private Android() {
        }

        @Override
        public Executor callbackExecutor() {
            return new MainThreadExecutor();
        }
    }

    private static class Base
    extends Platform {
        private Base() {
        }

        @Override
        public Executor callbackExecutor() {
            return new SynchronousExecutor();
        }
    }
}

