/*
 * Decompiled with CFR 0.152.
 */
package io.voucherify.client.model.voucher;

import io.voucherify.client.model.common.SortingOrder;

public class VoucherOrder {
    private SortingOrder order = SortingOrder.ASC;
    private String fieldName;

    public String asQueryParam() {
        if (this.order == null || this.fieldName == null) {
            return "";
        }
        return this.order.getSorting() + this.fieldName.toLowerCase();
    }

    public static VoucherOrderBuilder builder() {
        return new VoucherOrderBuilder();
    }

    private VoucherOrder() {
    }

    private VoucherOrder(SortingOrder order, String fieldName) {
        this.order = order;
        this.fieldName = fieldName;
    }

    public SortingOrder getOrder() {
        return this.order;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String toString() {
        return "VoucherOrder(order=" + (Object)((Object)this.getOrder()) + ", fieldName=" + this.getFieldName() + ")";
    }

    public static class VoucherOrderBuilder {
        private SortingOrder order;
        private String fieldName;

        VoucherOrderBuilder() {
        }

        public VoucherOrderBuilder order(SortingOrder order) {
            this.order = order;
            return this;
        }

        public VoucherOrderBuilder fieldName(String fieldName) {
            this.fieldName = fieldName;
            return this;
        }

        public VoucherOrder build() {
            return new VoucherOrder(this.order, this.fieldName);
        }

        public String toString() {
            return "VoucherOrder.VoucherOrderBuilder(order=" + (Object)((Object)this.order) + ", fieldName=" + this.fieldName + ")";
        }
    }
}

