/*
 * Decompiled with CFR 0.152.
 */
package io.voucherify.client;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import io.voucherify.client.ApiVersion;
import io.voucherify.client.api.VoucherifyApi;
import io.voucherify.client.error.VoucherifyErrorHandler;
import io.voucherify.client.json.converter.JsonConverter;
import io.voucherify.client.json.deserializer.CampaignsResponseDeserializer;
import io.voucherify.client.json.deserializer.DateDeserializer;
import io.voucherify.client.json.deserializer.VouchersResponseDeserializer;
import io.voucherify.client.json.serializer.DateSerializer;
import io.voucherify.client.model.campaign.response.CampaignsResponse;
import io.voucherify.client.model.voucher.response.VouchersResponse;
import io.voucherify.client.module.CampaignsModule;
import io.voucherify.client.module.CustomersModule;
import io.voucherify.client.module.DistributionsModule;
import io.voucherify.client.module.EventsModule;
import io.voucherify.client.module.OrdersModule;
import io.voucherify.client.module.ProductsModule;
import io.voucherify.client.module.PromotionsModule;
import io.voucherify.client.module.RedemptionsModule;
import io.voucherify.client.module.SegmentsModule;
import io.voucherify.client.module.ValidationRulesModule;
import io.voucherify.client.module.ValidationsModule;
import io.voucherify.client.module.VoucherModule;
import io.voucherify.client.utils.Platform;
import java.util.Date;
import java.util.concurrent.Executor;
import retrofit.ErrorHandler;
import retrofit.RequestInterceptor;
import retrofit.RestAdapter;
import retrofit.client.Client;
import retrofit.converter.Converter;

public class VoucherifyClient {
    private final String httpScheme;
    private VoucherModule voucherModule;
    private ValidationsModule validationsModule;
    private CustomersModule customersModule;
    private CampaignsModule campaignsModule;
    private RedemptionsModule redemptionsModule;
    private DistributionsModule distributionsModule;
    private ProductsModule productsModule;
    private SegmentsModule segmentsModule;
    private ValidationRulesModule validationRulesModule;
    private PromotionsModule promotionsModule;
    private final OrdersModule ordersModule;
    private final EventsModule eventsModule;
    private VoucherifyApi voucherifyApi;
    private Executor executor;

    private VoucherifyClient(Builder builder) {
        if (builder.clientSecretKey == null) {
            throw new IllegalArgumentException("App token must be defined.");
        }
        if (builder.appId == null) {
            throw new IllegalArgumentException("App ID must be defined.");
        }
        this.httpScheme = this.createHttpScheme(builder);
        this.executor = this.createCallbackExecutor();
        this.voucherifyApi = this.createRetrofitService(builder);
        this.voucherModule = new VoucherModule(this.voucherifyApi, this.executor);
        this.validationsModule = new ValidationsModule(this.voucherifyApi, this.executor);
        this.customersModule = new CustomersModule(this.voucherifyApi, this.executor);
        this.campaignsModule = new CampaignsModule(this.voucherifyApi, this.executor);
        this.redemptionsModule = new RedemptionsModule(this.voucherifyApi, this.executor);
        this.distributionsModule = new DistributionsModule(this.voucherifyApi, this.executor);
        this.productsModule = new ProductsModule(this.voucherifyApi, this.executor);
        this.segmentsModule = new SegmentsModule(this.voucherifyApi, this.executor);
        this.validationRulesModule = new ValidationRulesModule(this.voucherifyApi, this.executor);
        this.promotionsModule = new PromotionsModule(this.voucherifyApi, this.executor);
        this.ordersModule = new OrdersModule(this.voucherifyApi, this.executor);
        this.eventsModule = new EventsModule(this.voucherifyApi, this.executor);
    }

    public VoucherModule vouchers() {
        return this.voucherModule;
    }

    public ValidationsModule validations() {
        return this.validationsModule;
    }

    public CustomersModule customers() {
        return this.customersModule;
    }

    public CampaignsModule campaigns() {
        return this.campaignsModule;
    }

    public RedemptionsModule redemptions() {
        return this.redemptionsModule;
    }

    public DistributionsModule distributions() {
        return this.distributionsModule;
    }

    public ProductsModule products() {
        return this.productsModule;
    }

    public SegmentsModule segments() {
        return this.segmentsModule;
    }

    public ValidationRulesModule validationRules() {
        return this.validationRulesModule;
    }

    public PromotionsModule promotions() {
        return this.promotionsModule;
    }

    public OrdersModule orders() {
        return this.ordersModule;
    }

    public EventsModule events() {
        return this.eventsModule;
    }

    private Executor createCallbackExecutor() {
        return Platform.get().callbackExecutor();
    }

    private JsonConverter createConverter(Builder builder) {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        SimpleModule jsonParsingModule = new SimpleModule();
        jsonParsingModule.addSerializer(Date.class, (JsonSerializer)new DateSerializer("yyyy-MM-dd'T'HH:mm:ssXXX"));
        jsonParsingModule.addDeserializer(Date.class, (JsonDeserializer)new DateDeserializer("yyyy-MM-dd'T'HH:mm:ssXXX", "yyyy-MM-dd'T'HH:mm:ss.SSSXXX"));
        jsonParsingModule.addDeserializer(CampaignsResponse.class, (JsonDeserializer)new CampaignsResponseDeserializer(builder.apiVersion));
        jsonParsingModule.addDeserializer(VouchersResponse.class, (JsonDeserializer)new VouchersResponseDeserializer(builder.apiVersion));
        mapper.registerModule((Module)jsonParsingModule);
        return new JsonConverter(mapper);
    }

    private String createHttpScheme(Builder builder) {
        if (builder.secure) {
            return "https";
        }
        return "http";
    }

    private VoucherifyApi createRetrofitService(Builder builder) {
        RestAdapter.Builder restBuilder = new RestAdapter.Builder().setConverter((Converter)this.createConverter(builder)).setRequestInterceptor(this.createInterceptor(builder));
        this.setEndPoint(builder, restBuilder);
        this.setClientProvider(builder, restBuilder);
        this.setLogLevel(builder, restBuilder);
        this.setErrorHandler(restBuilder);
        return (VoucherifyApi)restBuilder.build().create(VoucherifyApi.class);
    }

    private RequestInterceptor createInterceptor(final Builder builder) {
        return new RequestInterceptor(){

            public void intercept(RequestInterceptor.RequestFacade request) {
                request.addHeader("X-Voucherify-Channel", "Java-SDK");
                request.addHeader("X-App-Id", builder.appId);
                request.addHeader("X-App-Token", builder.clientSecretKey);
                if (builder.apiVersion != null) {
                    request.addHeader("X-Voucherify-API-Version", builder.apiVersion.getValue());
                } else {
                    request.addHeader("X-Voucherify-API-Version", ApiVersion.V_2018_08_01.getValue());
                }
            }
        };
    }

    private void setLogLevel(Builder builder, RestAdapter.Builder restBuilder) {
        if (builder.logLevel != null) {
            restBuilder.setLogLevel(builder.logLevel);
        }
    }

    private void setClientProvider(Builder builder, RestAdapter.Builder restBuilder) {
        if (builder.clientProvider != null) {
            restBuilder.setClient(builder.clientProvider);
        }
    }

    private void setEndPoint(Builder builder, RestAdapter.Builder restBuilder) {
        String endpoint = builder.endpoint == null ? "api.voucherify.io/v1/" : builder.endpoint;
        restBuilder.setEndpoint(String.format("%s://%s", this.httpScheme, endpoint));
    }

    private void setErrorHandler(RestAdapter.Builder restBuilder) {
        restBuilder.setErrorHandler((ErrorHandler)new VoucherifyErrorHandler());
    }

    public static class Builder {
        String clientSecretKey;
        String appId;
        String endpoint;
        boolean secure = true;
        RestAdapter.LogLevel logLevel;
        Client.Provider clientProvider;
        ApiVersion apiVersion;

        public Builder setClientSecretKey(String clientSecretKey) {
            if (clientSecretKey == null) {
                throw new IllegalArgumentException("Cannot call setClientSecretKey() with null.");
            }
            this.clientSecretKey = clientSecretKey;
            return this;
        }

        public Builder setAppId(String appId) {
            if (appId == null) {
                throw new IllegalArgumentException("Cannot call setAppId() with null.");
            }
            this.appId = appId;
            return this;
        }

        public Builder setClient(final Client client) {
            if (client == null) {
                throw new IllegalArgumentException("Cannot call setClient() with null.");
            }
            return this.setClientProvider(new Client.Provider(){

                public Client get() {
                    return client;
                }
            });
        }

        public Builder setEndpoint(String remoteUrl) {
            if (remoteUrl == null) {
                throw new IllegalArgumentException("Cannot call setEndpoint() with null.");
            }
            this.endpoint = remoteUrl;
            System.out.println(remoteUrl);
            return this;
        }

        public Builder setClientProvider(Client.Provider clientProvider) {
            if (clientProvider == null) {
                throw new IllegalArgumentException("Cannot call setClientProvider() with null.");
            }
            this.clientProvider = clientProvider;
            return this;
        }

        public Builder setLogLevel(RestAdapter.LogLevel logLevel) {
            if (logLevel == null) {
                throw new IllegalArgumentException("Cannot call setLogLevel() with null.");
            }
            this.logLevel = logLevel;
            return this;
        }

        public Builder withSSL() {
            this.secure = true;
            return this;
        }

        public Builder withoutSSL() {
            this.secure = false;
            return this;
        }

        public Builder apiVersion(ApiVersion version) {
            this.apiVersion = version;
            return this;
        }

        public VoucherifyClient build() {
            return new VoucherifyClient(this);
        }
    }
}

