/*
 * Decompiled with CFR 0.152.
 */
package io.voucherify.client.model.voucher;

import io.voucherify.client.utils.AbstractFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class VouchersFilter
extends AbstractFilter<String, Object> {
    private Integer limit;
    private Integer page;
    private String category;
    private String campaign;
    private String customer;
    private List<Filter> filters;

    @Override
    public Map<String, Object> asMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("limit", this.limit);
        map.put("page", this.page);
        map.put("category", this.category);
        map.put("campaign", this.campaign);
        map.put("customer", this.customer);
        if (this.filters != null) {
            for (Filter filter : this.filters) {
                if (filter == null) continue;
                map.put(filter.asKey(), filter.getValue());
            }
        }
        return map;
    }

    public static VouchersFilterBuilder builder() {
        return new VouchersFilterBuilder();
    }

    private VouchersFilter() {
    }

    private VouchersFilter(Integer limit, Integer page, String category, String campaign, String customer, List<Filter> filters) {
        this.limit = limit;
        this.page = page;
        this.category = category;
        this.campaign = campaign;
        this.customer = customer;
        this.filters = filters;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public Integer getPage() {
        return this.page;
    }

    public String getCategory() {
        return this.category;
    }

    public String getCampaign() {
        return this.campaign;
    }

    public String getCustomer() {
        return this.customer;
    }

    public List<Filter> getFilters() {
        return this.filters;
    }

    public String toString() {
        return "VouchersFilter(limit=" + this.getLimit() + ", page=" + this.getPage() + ", category=" + this.getCategory() + ", campaign=" + this.getCampaign() + ", customer=" + this.getCustomer() + ", filters=" + this.getFilters() + ")";
    }

    public static class VouchersFilterBuilder {
        private Integer limit;
        private Integer page;
        private String category;
        private String campaign;
        private String customer;
        private ArrayList<Filter> filters;

        VouchersFilterBuilder() {
        }

        public VouchersFilterBuilder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public VouchersFilterBuilder page(Integer page) {
            this.page = page;
            return this;
        }

        public VouchersFilterBuilder category(String category) {
            this.category = category;
            return this;
        }

        public VouchersFilterBuilder campaign(String campaign) {
            this.campaign = campaign;
            return this;
        }

        public VouchersFilterBuilder customer(String customer) {
            this.customer = customer;
            return this;
        }

        public VouchersFilterBuilder filter(Filter filter) {
            if (this.filters == null) {
                this.filters = new ArrayList();
            }
            this.filters.add(filter);
            return this;
        }

        public VouchersFilterBuilder filters(Collection<? extends Filter> filters) {
            if (this.filters == null) {
                this.filters = new ArrayList();
            }
            this.filters.addAll(filters);
            return this;
        }

        public VouchersFilterBuilder clearFilters() {
            if (this.filters != null) {
                this.filters.clear();
            }
            return this;
        }

        public VouchersFilter build() {
            List<Object> filters;
            switch (this.filters == null ? 0 : this.filters.size()) {
                case 0: {
                    filters = Collections.emptyList();
                    break;
                }
                case 1: {
                    filters = Collections.singletonList(this.filters.get(0));
                    break;
                }
                default: {
                    filters = Collections.unmodifiableList(new ArrayList<Filter>(this.filters));
                }
            }
            return new VouchersFilter(this.limit, this.page, this.category, this.campaign, this.customer, filters);
        }

        public String toString() {
            return "VouchersFilter.VouchersFilterBuilder(limit=" + this.limit + ", page=" + this.page + ", category=" + this.category + ", campaign=" + this.campaign + ", customer=" + this.customer + ", filters=" + this.filters + ")";
        }
    }

    public static class Filter {
        private String fieldName;
        private String condition;
        private Object value;

        String asKey() {
            return "[filters][" + this.fieldName + "][conditions][" + this.condition + "]";
        }

        public static FilterBuilder builder() {
            return new FilterBuilder();
        }

        private Filter() {
        }

        private Filter(String fieldName, String condition, Object value) {
            this.fieldName = fieldName;
            this.condition = condition;
            this.value = value;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public String getCondition() {
            return this.condition;
        }

        public Object getValue() {
            return this.value;
        }

        public String toString() {
            return "VouchersFilter.Filter(fieldName=" + this.getFieldName() + ", condition=" + this.getCondition() + ", value=" + this.getValue() + ")";
        }

        public static class FilterBuilder {
            private String fieldName;
            private String condition;
            private Object value;

            FilterBuilder() {
            }

            public FilterBuilder fieldName(String fieldName) {
                this.fieldName = fieldName;
                return this;
            }

            public FilterBuilder condition(String condition) {
                this.condition = condition;
                return this;
            }

            public FilterBuilder value(Object value) {
                this.value = value;
                return this;
            }

            public Filter build() {
                return new Filter(this.fieldName, this.condition, this.value);
            }

            public String toString() {
                return "VouchersFilter.Filter.FilterBuilder(fieldName=" + this.fieldName + ", condition=" + this.condition + ", value=" + this.value + ")";
            }
        }
    }
}

