/*
 * Decompiled with CFR 0.152.
 */
package io.voucherify.client.model.order;

import io.voucherify.client.model.customer.Customer;
import io.voucherify.client.model.order.OrderItem;
import io.voucherify.client.model.order.OrderStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class UpdateOrder {
    private Customer customer;
    private Integer amount;
    private OrderStatus orderStatus;
    private List<OrderItem> items;
    private Map<String, Object> metadata;

    public static UpdateOrderBuilder builder() {
        return new UpdateOrderBuilder();
    }

    private UpdateOrder() {
    }

    private UpdateOrder(Customer customer, Integer amount, OrderStatus orderStatus, List<OrderItem> items, Map<String, Object> metadata) {
        this.customer = customer;
        this.amount = amount;
        this.orderStatus = orderStatus;
        this.items = items;
        this.metadata = metadata;
    }

    public Customer getCustomer() {
        return this.customer;
    }

    public Integer getAmount() {
        return this.amount;
    }

    public OrderStatus getOrderStatus() {
        return this.orderStatus;
    }

    public List<OrderItem> getItems() {
        return this.items;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public String toString() {
        return "UpdateOrder(customer=" + this.getCustomer() + ", amount=" + this.getAmount() + ", orderStatus=" + (Object)((Object)this.getOrderStatus()) + ", items=" + this.getItems() + ", metadata=" + this.getMetadata() + ")";
    }

    public static class UpdateOrderBuilder {
        private Customer customer;
        private Integer amount;
        private OrderStatus orderStatus;
        private ArrayList<OrderItem> items;
        private ArrayList<String> metadata$key;
        private ArrayList<Object> metadata$value;

        UpdateOrderBuilder() {
        }

        public UpdateOrderBuilder customer(Customer customer) {
            this.customer = customer;
            return this;
        }

        public UpdateOrderBuilder amount(Integer amount) {
            this.amount = amount;
            return this;
        }

        public UpdateOrderBuilder orderStatus(OrderStatus orderStatus) {
            this.orderStatus = orderStatus;
            return this;
        }

        public UpdateOrderBuilder item(OrderItem item) {
            if (this.items == null) {
                this.items = new ArrayList();
            }
            this.items.add(item);
            return this;
        }

        public UpdateOrderBuilder items(Collection<? extends OrderItem> items) {
            if (this.items == null) {
                this.items = new ArrayList();
            }
            this.items.addAll(items);
            return this;
        }

        public UpdateOrderBuilder clearItems() {
            if (this.items != null) {
                this.items.clear();
            }
            return this;
        }

        public UpdateOrderBuilder metadataEntry(String metadataEntryKey, Object metadataEntryValue) {
            if (this.metadata$key == null) {
                this.metadata$key = new ArrayList();
                this.metadata$value = new ArrayList();
            }
            this.metadata$key.add(metadataEntryKey);
            this.metadata$value.add(metadataEntryValue);
            return this;
        }

        public UpdateOrderBuilder metadata(Map<? extends String, ? extends Object> metadata) {
            if (this.metadata$key == null) {
                this.metadata$key = new ArrayList();
                this.metadata$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends Object> $lombokEntry : metadata.entrySet()) {
                this.metadata$key.add($lombokEntry.getKey());
                this.metadata$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public UpdateOrderBuilder clearMetadata() {
            if (this.metadata$key != null) {
                this.metadata$key.clear();
                this.metadata$value.clear();
            }
            return this;
        }

        public UpdateOrder build() {
            Map<Object, Object> metadata;
            List<Object> items;
            switch (this.items == null ? 0 : this.items.size()) {
                case 0: {
                    items = Collections.emptyList();
                    break;
                }
                case 1: {
                    items = Collections.singletonList(this.items.get(0));
                    break;
                }
                default: {
                    items = Collections.unmodifiableList(new ArrayList<OrderItem>(this.items));
                }
            }
            switch (this.metadata$key == null ? 0 : this.metadata$key.size()) {
                case 0: {
                    metadata = Collections.emptyMap();
                    break;
                }
                case 1: {
                    metadata = Collections.singletonMap(this.metadata$key.get(0), this.metadata$value.get(0));
                    break;
                }
                default: {
                    metadata = new LinkedHashMap(this.metadata$key.size() < 0x40000000 ? 1 + this.metadata$key.size() + (this.metadata$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.metadata$key.size(); ++$i) {
                        metadata.put(this.metadata$key.get($i), this.metadata$value.get($i));
                    }
                    metadata = Collections.unmodifiableMap(metadata);
                }
            }
            return new UpdateOrder(this.customer, this.amount, this.orderStatus, items, metadata);
        }

        public String toString() {
            return "UpdateOrder.UpdateOrderBuilder(customer=" + this.customer + ", amount=" + this.amount + ", orderStatus=" + (Object)((Object)this.orderStatus) + ", items=" + this.items + ", metadata$key=" + this.metadata$key + ", metadata$value=" + this.metadata$value + ")";
        }
    }
}

