/*
 * Decompiled with CFR 0.152.
 */
package io.voucherify.client.model.order;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.voucherify.client.model.order.OrderItem;
import io.voucherify.client.model.order.OrderStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class Order {
    @JsonProperty(value="result")
    private OrderStatus status;
    private Integer amount;
    private List<OrderItem> items;

    public static OrderBuilder builder() {
        return new OrderBuilder();
    }

    private Order() {
    }

    private Order(OrderStatus status, Integer amount, List<OrderItem> items) {
        this.status = status;
        this.amount = amount;
        this.items = items;
    }

    public OrderStatus getStatus() {
        return this.status;
    }

    public Integer getAmount() {
        return this.amount;
    }

    public List<OrderItem> getItems() {
        return this.items;
    }

    public String toString() {
        return "Order(status=" + (Object)((Object)this.getStatus()) + ", amount=" + this.getAmount() + ", items=" + this.getItems() + ")";
    }

    public static class OrderBuilder {
        private OrderStatus status;
        private Integer amount;
        private ArrayList<OrderItem> items;

        OrderBuilder() {
        }

        public OrderBuilder status(OrderStatus status) {
            this.status = status;
            return this;
        }

        public OrderBuilder amount(Integer amount) {
            this.amount = amount;
            return this;
        }

        public OrderBuilder item(OrderItem item) {
            if (this.items == null) {
                this.items = new ArrayList();
            }
            this.items.add(item);
            return this;
        }

        public OrderBuilder items(Collection<? extends OrderItem> items) {
            if (this.items == null) {
                this.items = new ArrayList();
            }
            this.items.addAll(items);
            return this;
        }

        public OrderBuilder clearItems() {
            if (this.items != null) {
                this.items.clear();
            }
            return this;
        }

        public Order build() {
            List<Object> items;
            switch (this.items == null ? 0 : this.items.size()) {
                case 0: {
                    items = Collections.emptyList();
                    break;
                }
                case 1: {
                    items = Collections.singletonList(this.items.get(0));
                    break;
                }
                default: {
                    items = Collections.unmodifiableList(new ArrayList<OrderItem>(this.items));
                }
            }
            return new Order(this.status, this.amount, items);
        }

        public String toString() {
            return "Order.OrderBuilder(status=" + (Object)((Object)this.status) + ", amount=" + this.amount + ", items=" + this.items + ")";
        }
    }
}

