/*
 * Decompiled with CFR 0.152.
 */
package io.voucherify.client.model.distribution;

import io.voucherify.client.model.distribution.ListPublicationsFilters;
import io.voucherify.client.model.distribution.ListPublicationsOrder;
import io.voucherify.client.model.voucher.VoucherType;
import io.voucherify.client.utils.AbstractFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ListPublicationsFilter
extends AbstractFilter<String, Object> {
    private Integer limit;
    private Integer page;
    private ListPublicationsOrder order;
    private String campaign;
    private String voucher;
    private String result;
    private VoucherType voucherType;
    private Boolean isReferralCode;
    private List<ListPublicationsFilters> filters;

    @Override
    public Map<String, Object> asMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("limit", this.limit);
        map.put("page", this.page);
        map.put("order", this.order != null ? this.order.getValue() : null);
        map.put("campaign", this.campaign);
        map.put("voucher", this.voucher);
        map.put("result", this.result);
        map.put("voucher_type", (Object)this.voucherType);
        map.put("is_referral_code", this.isReferralCode);
        this.attachFilters(map);
        return map;
    }

    private void attachFilters(Map<String, Object> map) {
        if (this.filters == null || this.filters.isEmpty()) {
            return;
        }
        for (ListPublicationsFilters filter : this.filters) {
            map.put(filter.buildFilterParam(), filter.getValue());
        }
    }

    public static ListPublicationsFilterBuilder builder() {
        return new ListPublicationsFilterBuilder();
    }

    private ListPublicationsFilter() {
    }

    private ListPublicationsFilter(Integer limit, Integer page, ListPublicationsOrder order, String campaign, String voucher, String result, VoucherType voucherType, Boolean isReferralCode, List<ListPublicationsFilters> filters) {
        this.limit = limit;
        this.page = page;
        this.order = order;
        this.campaign = campaign;
        this.voucher = voucher;
        this.result = result;
        this.voucherType = voucherType;
        this.isReferralCode = isReferralCode;
        this.filters = filters;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public Integer getPage() {
        return this.page;
    }

    public ListPublicationsOrder getOrder() {
        return this.order;
    }

    public String getCampaign() {
        return this.campaign;
    }

    public String getVoucher() {
        return this.voucher;
    }

    public String getResult() {
        return this.result;
    }

    public VoucherType getVoucherType() {
        return this.voucherType;
    }

    public Boolean getIsReferralCode() {
        return this.isReferralCode;
    }

    public List<ListPublicationsFilters> getFilters() {
        return this.filters;
    }

    public String toString() {
        return "ListPublicationsFilter(limit=" + this.getLimit() + ", page=" + this.getPage() + ", order=" + (Object)((Object)this.getOrder()) + ", campaign=" + this.getCampaign() + ", voucher=" + this.getVoucher() + ", result=" + this.getResult() + ", voucherType=" + (Object)((Object)this.getVoucherType()) + ", isReferralCode=" + this.getIsReferralCode() + ", filters=" + this.getFilters() + ")";
    }

    public static class ListPublicationsFilterBuilder {
        private Integer limit;
        private Integer page;
        private ListPublicationsOrder order;
        private String campaign;
        private String voucher;
        private String result;
        private VoucherType voucherType;
        private Boolean isReferralCode;
        private ArrayList<ListPublicationsFilters> filters;

        ListPublicationsFilterBuilder() {
        }

        public ListPublicationsFilterBuilder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public ListPublicationsFilterBuilder page(Integer page) {
            this.page = page;
            return this;
        }

        public ListPublicationsFilterBuilder order(ListPublicationsOrder order) {
            this.order = order;
            return this;
        }

        public ListPublicationsFilterBuilder campaign(String campaign) {
            this.campaign = campaign;
            return this;
        }

        public ListPublicationsFilterBuilder voucher(String voucher) {
            this.voucher = voucher;
            return this;
        }

        public ListPublicationsFilterBuilder result(String result) {
            this.result = result;
            return this;
        }

        public ListPublicationsFilterBuilder voucherType(VoucherType voucherType) {
            this.voucherType = voucherType;
            return this;
        }

        public ListPublicationsFilterBuilder isReferralCode(Boolean isReferralCode) {
            this.isReferralCode = isReferralCode;
            return this;
        }

        public ListPublicationsFilterBuilder filter(ListPublicationsFilters filter) {
            if (this.filters == null) {
                this.filters = new ArrayList();
            }
            this.filters.add(filter);
            return this;
        }

        public ListPublicationsFilterBuilder filters(Collection<? extends ListPublicationsFilters> filters) {
            if (this.filters == null) {
                this.filters = new ArrayList();
            }
            this.filters.addAll(filters);
            return this;
        }

        public ListPublicationsFilterBuilder clearFilters() {
            if (this.filters != null) {
                this.filters.clear();
            }
            return this;
        }

        public ListPublicationsFilter build() {
            List<Object> filters;
            switch (this.filters == null ? 0 : this.filters.size()) {
                case 0: {
                    filters = Collections.emptyList();
                    break;
                }
                case 1: {
                    filters = Collections.singletonList(this.filters.get(0));
                    break;
                }
                default: {
                    filters = Collections.unmodifiableList(new ArrayList<ListPublicationsFilters>(this.filters));
                }
            }
            return new ListPublicationsFilter(this.limit, this.page, this.order, this.campaign, this.voucher, this.result, this.voucherType, this.isReferralCode, filters);
        }

        public String toString() {
            return "ListPublicationsFilter.ListPublicationsFilterBuilder(limit=" + this.limit + ", page=" + this.page + ", order=" + (Object)((Object)this.order) + ", campaign=" + this.campaign + ", voucher=" + this.voucher + ", result=" + this.result + ", voucherType=" + (Object)((Object)this.voucherType) + ", isReferralCode=" + this.isReferralCode + ", filters=" + this.filters + ")";
        }
    }
}

