/*
 * Decompiled with CFR 0.152.
 */
package io.voucherify.client.model.customer;

import com.fasterxml.jackson.annotation.JsonProperty;

public class Address {
    private String city;
    private String state;
    @JsonProperty(value="line_1")
    private String line1;
    @JsonProperty(value="line_2")
    private String line2;
    private String country;
    @JsonProperty(value="postal_code")
    private String postalCode;

    public static AddressBuilder builder() {
        return new AddressBuilder();
    }

    private Address() {
    }

    private Address(String city, String state, String line1, String line2, String country, String postalCode) {
        this.city = city;
        this.state = state;
        this.line1 = line1;
        this.line2 = line2;
        this.country = country;
        this.postalCode = postalCode;
    }

    public String getCity() {
        return this.city;
    }

    public String getState() {
        return this.state;
    }

    public String getLine1() {
        return this.line1;
    }

    public String getLine2() {
        return this.line2;
    }

    public String getCountry() {
        return this.country;
    }

    public String getPostalCode() {
        return this.postalCode;
    }

    public String toString() {
        return "Address(city=" + this.getCity() + ", state=" + this.getState() + ", line1=" + this.getLine1() + ", line2=" + this.getLine2() + ", country=" + this.getCountry() + ", postalCode=" + this.getPostalCode() + ")";
    }

    public static class AddressBuilder {
        private String city;
        private String state;
        private String line1;
        private String line2;
        private String country;
        private String postalCode;

        AddressBuilder() {
        }

        public AddressBuilder city(String city) {
            this.city = city;
            return this;
        }

        public AddressBuilder state(String state) {
            this.state = state;
            return this;
        }

        public AddressBuilder line1(String line1) {
            this.line1 = line1;
            return this;
        }

        public AddressBuilder line2(String line2) {
            this.line2 = line2;
            return this;
        }

        public AddressBuilder country(String country) {
            this.country = country;
            return this;
        }

        public AddressBuilder postalCode(String postalCode) {
            this.postalCode = postalCode;
            return this;
        }

        public Address build() {
            return new Address(this.city, this.state, this.line1, this.line2, this.country, this.postalCode);
        }

        public String toString() {
            return "Address.AddressBuilder(city=" + this.city + ", state=" + this.state + ", line1=" + this.line1 + ", line2=" + this.line2 + ", country=" + this.country + ", postalCode=" + this.postalCode + ")";
        }
    }
}

