/*
 * Decompiled with CFR 0.152.
 */
package io.voucherify.client.model.order;

import com.fasterxml.jackson.annotation.JsonProperty;

public class OrderItem {
    @JsonProperty(value="product_id")
    private String productId;
    @JsonProperty(value="sku_id")
    private String skuId;
    private Integer quantity;
    private Integer amount;
    private Integer price;

    public static OrderItemBuilder builder() {
        return new OrderItemBuilder();
    }

    private OrderItem() {
    }

    private OrderItem(String productId, String skuId, Integer quantity, Integer amount, Integer price) {
        this.productId = productId;
        this.skuId = skuId;
        this.quantity = quantity;
        this.amount = amount;
        this.price = price;
    }

    public String getProductId() {
        return this.productId;
    }

    public String getSkuId() {
        return this.skuId;
    }

    public Integer getQuantity() {
        return this.quantity;
    }

    public Integer getAmount() {
        return this.amount;
    }

    public Integer getPrice() {
        return this.price;
    }

    public String toString() {
        return "OrderItem(productId=" + this.getProductId() + ", skuId=" + this.getSkuId() + ", quantity=" + this.getQuantity() + ", amount=" + this.getAmount() + ", price=" + this.getPrice() + ")";
    }

    public static class OrderItemBuilder {
        private String productId;
        private String skuId;
        private Integer quantity;
        private Integer amount;
        private Integer price;

        OrderItemBuilder() {
        }

        public OrderItemBuilder productId(String productId) {
            this.productId = productId;
            return this;
        }

        public OrderItemBuilder skuId(String skuId) {
            this.skuId = skuId;
            return this;
        }

        public OrderItemBuilder quantity(Integer quantity) {
            this.quantity = quantity;
            return this;
        }

        public OrderItemBuilder amount(Integer amount) {
            this.amount = amount;
            return this;
        }

        public OrderItemBuilder price(Integer price) {
            this.price = price;
            return this;
        }

        public OrderItem build() {
            return new OrderItem(this.productId, this.skuId, this.quantity, this.amount, this.price);
        }

        public String toString() {
            return "OrderItem.OrderItemBuilder(productId=" + this.productId + ", skuId=" + this.skuId + ", quantity=" + this.quantity + ", amount=" + this.amount + ", price=" + this.price + ")";
        }
    }
}

