/*
 * Decompiled with CFR 0.152.
 */
package io.voucherify.client.utils;

import io.voucherify.client.callback.VoucherifyCallback;
import io.voucherify.client.error.VoucherifyError;
import java.util.concurrent.Executor;
import rx.Observable;
import rx.functions.Action1;
import rx.functions.Func0;
import rx.schedulers.Schedulers;

public final class RxUtils {
    public static <R> VoucherifyCallback<R> subscribe(final Executor executor, Observable<R> observable, final VoucherifyCallback<R> callback) {
        observable.subscribe(new Action1<R>(){

            public void call(final R r) {
                executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        callback.onSuccess(r);
                    }
                });
            }
        }, (Action1)new Action1<Throwable>(){

            public void call(final Throwable throwable) {
                executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        callback.onFailure(VoucherifyError.from(throwable));
                    }
                });
            }
        });
        return callback;
    }

    public static <R> Observable<R> defer(DefFunc<R> func) {
        return Observable.defer(func).subscribeOn(Schedulers.io());
    }

    public static abstract class DefFunc<T>
    implements Func0<Observable<T>> {
        public final Observable<T> call() {
            return Observable.just(this.method());
        }

        public abstract T method();
    }
}

