/*
 * Decompiled with CFR 0.152.
 */
package io.voucherify.client.model.event;

import io.voucherify.client.model.customer.Customer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class CustomEvent {
    private String event;
    private Customer customer;
    private Map<String, Object> metadata;

    public static CustomEventBuilder builder() {
        return new CustomEventBuilder();
    }

    private CustomEvent() {
    }

    private CustomEvent(String event, Customer customer, Map<String, Object> metadata) {
        this.event = event;
        this.customer = customer;
        this.metadata = metadata;
    }

    public String getEvent() {
        return this.event;
    }

    public Customer getCustomer() {
        return this.customer;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public String toString() {
        return "CustomEvent(event=" + this.getEvent() + ", customer=" + this.getCustomer() + ", metadata=" + this.getMetadata() + ")";
    }

    public static class CustomEventBuilder {
        private String event;
        private Customer customer;
        private ArrayList<String> metadata$key;
        private ArrayList<Object> metadata$value;

        CustomEventBuilder() {
        }

        public CustomEventBuilder event(String event) {
            this.event = event;
            return this;
        }

        public CustomEventBuilder customer(Customer customer) {
            this.customer = customer;
            return this;
        }

        public CustomEventBuilder metadataEntry(String metadataEntryKey, Object metadataEntryValue) {
            if (this.metadata$key == null) {
                this.metadata$key = new ArrayList();
                this.metadata$value = new ArrayList();
            }
            this.metadata$key.add(metadataEntryKey);
            this.metadata$value.add(metadataEntryValue);
            return this;
        }

        public CustomEventBuilder metadata(Map<? extends String, ? extends Object> metadata) {
            if (this.metadata$key == null) {
                this.metadata$key = new ArrayList();
                this.metadata$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends Object> $lombokEntry : metadata.entrySet()) {
                this.metadata$key.add($lombokEntry.getKey());
                this.metadata$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public CustomEventBuilder clearMetadata() {
            if (this.metadata$key != null) {
                this.metadata$key.clear();
                this.metadata$value.clear();
            }
            return this;
        }

        public CustomEvent build() {
            Map<Object, Object> metadata;
            switch (this.metadata$key == null ? 0 : this.metadata$key.size()) {
                case 0: {
                    metadata = Collections.emptyMap();
                    break;
                }
                case 1: {
                    metadata = Collections.singletonMap(this.metadata$key.get(0), this.metadata$value.get(0));
                    break;
                }
                default: {
                    metadata = new LinkedHashMap(this.metadata$key.size() < 0x40000000 ? 1 + this.metadata$key.size() + (this.metadata$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.metadata$key.size(); ++$i) {
                        metadata.put(this.metadata$key.get($i), this.metadata$value.get($i));
                    }
                    metadata = Collections.unmodifiableMap(metadata);
                }
            }
            return new CustomEvent(this.event, this.customer, metadata);
        }

        public String toString() {
            return "CustomEvent.CustomEventBuilder(event=" + this.event + ", customer=" + this.customer + ", metadata$key=" + this.metadata$key + ", metadata$value=" + this.metadata$value + ")";
        }
    }
}

