/*
 * Decompiled with CFR 0.152.
 */
package io.voucherify.client.model.voucher;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.voucherify.client.model.voucher.DiscountType;

public class Discount {
    private DiscountType type;
    @JsonProperty(value="amount_off")
    private Integer amountOff;
    @JsonProperty(value="percent_off")
    private Double percentOff;
    @JsonProperty(value="amount_limit")
    private Integer amountLimit;
    @JsonProperty(value="unit_off")
    private Double unitOff;
    @JsonProperty(value="unit_type")
    private String unitType;

    public static Discount from(DiscountType type, int value) {
        Discount discount = new Discount();
        discount.type = type;
        switch (type) {
            case AMOUNT: {
                discount.amountOff = value;
                break;
            }
            case PERCENT: {
                discount.percentOff = (double)value / 100.0;
                break;
            }
            case UNIT: {
                discount.unitOff = (double)value / 100.0;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported discount type: " + (Object)((Object)type));
            }
        }
        return discount;
    }

    public static Discount amountOff(int amountOff) {
        Discount discount = new Discount();
        discount.type = DiscountType.AMOUNT;
        discount.amountOff = amountOff;
        return discount;
    }

    public static Discount percentOff(double percentOff) {
        return Discount.percentOff(percentOff, null);
    }

    public static Discount percentOff(double percentOff, Integer amountLimit) {
        Discount discount = new Discount();
        discount.type = DiscountType.PERCENT;
        discount.percentOff = percentOff;
        discount.amountLimit = amountLimit;
        return discount;
    }

    public static Discount unitOff(double unitOff) {
        Discount discount = new Discount();
        discount.type = DiscountType.UNIT;
        discount.unitOff = unitOff;
        return discount;
    }

    private Discount() {
    }

    private Discount(DiscountType type, Integer amountOff, Double percentOff, Integer amountLimit, Double unitOff, String unitType) {
        this.type = type;
        this.amountOff = amountOff;
        this.percentOff = percentOff;
        this.amountLimit = amountLimit;
        this.unitOff = unitOff;
        this.unitType = unitType;
    }

    public DiscountType getType() {
        return this.type;
    }

    public Integer getAmountOff() {
        return this.amountOff;
    }

    public Double getPercentOff() {
        return this.percentOff;
    }

    public Integer getAmountLimit() {
        return this.amountLimit;
    }

    public Double getUnitOff() {
        return this.unitOff;
    }

    public String getUnitType() {
        return this.unitType;
    }

    public String toString() {
        return "Discount(type=" + (Object)((Object)this.getType()) + ", amountOff=" + this.getAmountOff() + ", percentOff=" + this.getPercentOff() + ", amountLimit=" + this.getAmountLimit() + ", unitOff=" + this.getUnitOff() + ", unitType=" + this.getUnitType() + ")";
    }
}

