/*
 * Decompiled with CFR 0.152.
 */
package io.voucherify.client.model.product;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class SKU {
    private String id;
    private String sku;
    @JsonProperty(value="source_id")
    private String sourceId;
    private Map<String, Object> attributes;
    private Map<String, Object> metadata;

    public static SKUBuilder builder() {
        return new SKUBuilder();
    }

    private SKU() {
    }

    private SKU(String id, String sku, String sourceId, Map<String, Object> attributes, Map<String, Object> metadata) {
        this.id = id;
        this.sku = sku;
        this.sourceId = sourceId;
        this.attributes = attributes;
        this.metadata = metadata;
    }

    public String getId() {
        return this.id;
    }

    public String getSku() {
        return this.sku;
    }

    public String getSourceId() {
        return this.sourceId;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public String toString() {
        return "SKU(id=" + this.getId() + ", sku=" + this.getSku() + ", sourceId=" + this.getSourceId() + ", attributes=" + this.getAttributes() + ", metadata=" + this.getMetadata() + ")";
    }

    public static class SKUBuilder {
        private String id;
        private String sku;
        private String sourceId;
        private ArrayList<String> attributes$key;
        private ArrayList<Object> attributes$value;
        private ArrayList<String> metadata$key;
        private ArrayList<Object> metadata$value;

        SKUBuilder() {
        }

        public SKUBuilder id(String id) {
            this.id = id;
            return this;
        }

        public SKUBuilder sku(String sku) {
            this.sku = sku;
            return this;
        }

        public SKUBuilder sourceId(String sourceId) {
            this.sourceId = sourceId;
            return this;
        }

        public SKUBuilder attribute(String attributeKey, Object attributeValue) {
            if (this.attributes$key == null) {
                this.attributes$key = new ArrayList();
                this.attributes$value = new ArrayList();
            }
            this.attributes$key.add(attributeKey);
            this.attributes$value.add(attributeValue);
            return this;
        }

        public SKUBuilder attributes(Map<? extends String, ? extends Object> attributes) {
            if (this.attributes$key == null) {
                this.attributes$key = new ArrayList();
                this.attributes$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends Object> $lombokEntry : attributes.entrySet()) {
                this.attributes$key.add($lombokEntry.getKey());
                this.attributes$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public SKUBuilder clearAttributes() {
            if (this.attributes$key != null) {
                this.attributes$key.clear();
                this.attributes$value.clear();
            }
            return this;
        }

        public SKUBuilder metadataEntry(String metadataEntryKey, Object metadataEntryValue) {
            if (this.metadata$key == null) {
                this.metadata$key = new ArrayList();
                this.metadata$value = new ArrayList();
            }
            this.metadata$key.add(metadataEntryKey);
            this.metadata$value.add(metadataEntryValue);
            return this;
        }

        public SKUBuilder metadata(Map<? extends String, ? extends Object> metadata) {
            if (this.metadata$key == null) {
                this.metadata$key = new ArrayList();
                this.metadata$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends Object> $lombokEntry : metadata.entrySet()) {
                this.metadata$key.add($lombokEntry.getKey());
                this.metadata$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public SKUBuilder clearMetadata() {
            if (this.metadata$key != null) {
                this.metadata$key.clear();
                this.metadata$value.clear();
            }
            return this;
        }

        public SKU build() {
            Map<Object, Object> metadata;
            Map<Object, Object> attributes;
            switch (this.attributes$key == null ? 0 : this.attributes$key.size()) {
                case 0: {
                    attributes = Collections.emptyMap();
                    break;
                }
                case 1: {
                    attributes = Collections.singletonMap(this.attributes$key.get(0), this.attributes$value.get(0));
                    break;
                }
                default: {
                    attributes = new LinkedHashMap(this.attributes$key.size() < 0x40000000 ? 1 + this.attributes$key.size() + (this.attributes$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.attributes$key.size(); ++$i) {
                        attributes.put(this.attributes$key.get($i), this.attributes$value.get($i));
                    }
                    attributes = Collections.unmodifiableMap(attributes);
                }
            }
            switch (this.metadata$key == null ? 0 : this.metadata$key.size()) {
                case 0: {
                    metadata = Collections.emptyMap();
                    break;
                }
                case 1: {
                    metadata = Collections.singletonMap(this.metadata$key.get(0), this.metadata$value.get(0));
                    break;
                }
                default: {
                    metadata = new LinkedHashMap(this.metadata$key.size() < 0x40000000 ? 1 + this.metadata$key.size() + (this.metadata$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.metadata$key.size(); ++$i) {
                        metadata.put(this.metadata$key.get($i), this.metadata$value.get($i));
                    }
                    metadata = Collections.unmodifiableMap(metadata);
                }
            }
            return new SKU(this.id, this.sku, this.sourceId, attributes, metadata);
        }

        public String toString() {
            return "SKU.SKUBuilder(id=" + this.id + ", sku=" + this.sku + ", sourceId=" + this.sourceId + ", attributes$key=" + this.attributes$key + ", attributes$value=" + this.attributes$value + ", metadata$key=" + this.metadata$key + ", metadata$value=" + this.metadata$value + ")";
        }
    }
}

