/*
 * Decompiled with CFR 0.152.
 */
package io.voucherify.client.model.validationRules;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.voucherify.client.model.Operator;
import io.voucherify.client.model.validationRules.Junction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class OrderValidationRules {
    private Junction junction;
    @JsonProperty(value="total_amount")
    private Map<Operator, List<Integer>> totalAmount;
    @JsonProperty(value="products_count")
    private Map<Operator, List<Integer>> productsCount;
    @JsonProperty(value="all_orders_total_amount")
    private Map<Operator, List<Integer>> allOrdersTotalAmount;
    @JsonProperty(value="all_orders_discount_amount")
    private Map<Operator, List<Integer>> allOrdersDiscountAmount;

    public static OrderValidationRulesBuilder builder() {
        return new OrderValidationRulesBuilder();
    }

    private OrderValidationRules() {
    }

    private OrderValidationRules(Junction junction, Map<Operator, List<Integer>> totalAmount, Map<Operator, List<Integer>> productsCount, Map<Operator, List<Integer>> allOrdersTotalAmount, Map<Operator, List<Integer>> allOrdersDiscountAmount) {
        this.junction = junction;
        this.totalAmount = totalAmount;
        this.productsCount = productsCount;
        this.allOrdersTotalAmount = allOrdersTotalAmount;
        this.allOrdersDiscountAmount = allOrdersDiscountAmount;
    }

    public Junction getJunction() {
        return this.junction;
    }

    public Map<Operator, List<Integer>> getTotalAmount() {
        return this.totalAmount;
    }

    public Map<Operator, List<Integer>> getProductsCount() {
        return this.productsCount;
    }

    public Map<Operator, List<Integer>> getAllOrdersTotalAmount() {
        return this.allOrdersTotalAmount;
    }

    public Map<Operator, List<Integer>> getAllOrdersDiscountAmount() {
        return this.allOrdersDiscountAmount;
    }

    public String toString() {
        return "OrderValidationRules(junction=" + (Object)((Object)this.getJunction()) + ", totalAmount=" + this.getTotalAmount() + ", productsCount=" + this.getProductsCount() + ", allOrdersTotalAmount=" + this.getAllOrdersTotalAmount() + ", allOrdersDiscountAmount=" + this.getAllOrdersDiscountAmount() + ")";
    }

    public static class OrderValidationRulesBuilder {
        private Junction junction;
        private ArrayList<Operator> totalAmount$key;
        private ArrayList<List<Integer>> totalAmount$value;
        private ArrayList<Operator> productsCount$key;
        private ArrayList<List<Integer>> productsCount$value;
        private ArrayList<Operator> allOrdersTotalAmount$key;
        private ArrayList<List<Integer>> allOrdersTotalAmount$value;
        private ArrayList<Operator> allOrdersDiscountAmount$key;
        private ArrayList<List<Integer>> allOrdersDiscountAmount$value;

        OrderValidationRulesBuilder() {
        }

        public OrderValidationRulesBuilder junction(Junction junction) {
            this.junction = junction;
            return this;
        }

        public OrderValidationRulesBuilder totalAmountCondition(Operator totalAmountConditionKey, List<Integer> totalAmountConditionValue) {
            if (this.totalAmount$key == null) {
                this.totalAmount$key = new ArrayList();
                this.totalAmount$value = new ArrayList();
            }
            this.totalAmount$key.add(totalAmountConditionKey);
            this.totalAmount$value.add(totalAmountConditionValue);
            return this;
        }

        public OrderValidationRulesBuilder totalAmount(Map<? extends Operator, ? extends List<Integer>> totalAmount) {
            if (this.totalAmount$key == null) {
                this.totalAmount$key = new ArrayList();
                this.totalAmount$value = new ArrayList();
            }
            for (Map.Entry<? extends Operator, ? extends List<Integer>> $lombokEntry : totalAmount.entrySet()) {
                this.totalAmount$key.add($lombokEntry.getKey());
                this.totalAmount$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public OrderValidationRulesBuilder clearTotalAmount() {
            if (this.totalAmount$key != null) {
                this.totalAmount$key.clear();
                this.totalAmount$value.clear();
            }
            return this;
        }

        public OrderValidationRulesBuilder productsCountCondition(Operator productsCountConditionKey, List<Integer> productsCountConditionValue) {
            if (this.productsCount$key == null) {
                this.productsCount$key = new ArrayList();
                this.productsCount$value = new ArrayList();
            }
            this.productsCount$key.add(productsCountConditionKey);
            this.productsCount$value.add(productsCountConditionValue);
            return this;
        }

        public OrderValidationRulesBuilder productsCount(Map<? extends Operator, ? extends List<Integer>> productsCount) {
            if (this.productsCount$key == null) {
                this.productsCount$key = new ArrayList();
                this.productsCount$value = new ArrayList();
            }
            for (Map.Entry<? extends Operator, ? extends List<Integer>> $lombokEntry : productsCount.entrySet()) {
                this.productsCount$key.add($lombokEntry.getKey());
                this.productsCount$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public OrderValidationRulesBuilder clearProductsCount() {
            if (this.productsCount$key != null) {
                this.productsCount$key.clear();
                this.productsCount$value.clear();
            }
            return this;
        }

        public OrderValidationRulesBuilder allOrdersTotalAmountCondition(Operator allOrdersTotalAmountConditionKey, List<Integer> allOrdersTotalAmountConditionValue) {
            if (this.allOrdersTotalAmount$key == null) {
                this.allOrdersTotalAmount$key = new ArrayList();
                this.allOrdersTotalAmount$value = new ArrayList();
            }
            this.allOrdersTotalAmount$key.add(allOrdersTotalAmountConditionKey);
            this.allOrdersTotalAmount$value.add(allOrdersTotalAmountConditionValue);
            return this;
        }

        public OrderValidationRulesBuilder allOrdersTotalAmount(Map<? extends Operator, ? extends List<Integer>> allOrdersTotalAmount) {
            if (this.allOrdersTotalAmount$key == null) {
                this.allOrdersTotalAmount$key = new ArrayList();
                this.allOrdersTotalAmount$value = new ArrayList();
            }
            for (Map.Entry<? extends Operator, ? extends List<Integer>> $lombokEntry : allOrdersTotalAmount.entrySet()) {
                this.allOrdersTotalAmount$key.add($lombokEntry.getKey());
                this.allOrdersTotalAmount$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public OrderValidationRulesBuilder clearAllOrdersTotalAmount() {
            if (this.allOrdersTotalAmount$key != null) {
                this.allOrdersTotalAmount$key.clear();
                this.allOrdersTotalAmount$value.clear();
            }
            return this;
        }

        public OrderValidationRulesBuilder allOrdersDiscountAmountCondition(Operator allOrdersDiscountAmountConditionKey, List<Integer> allOrdersDiscountAmountConditionValue) {
            if (this.allOrdersDiscountAmount$key == null) {
                this.allOrdersDiscountAmount$key = new ArrayList();
                this.allOrdersDiscountAmount$value = new ArrayList();
            }
            this.allOrdersDiscountAmount$key.add(allOrdersDiscountAmountConditionKey);
            this.allOrdersDiscountAmount$value.add(allOrdersDiscountAmountConditionValue);
            return this;
        }

        public OrderValidationRulesBuilder allOrdersDiscountAmount(Map<? extends Operator, ? extends List<Integer>> allOrdersDiscountAmount) {
            if (this.allOrdersDiscountAmount$key == null) {
                this.allOrdersDiscountAmount$key = new ArrayList();
                this.allOrdersDiscountAmount$value = new ArrayList();
            }
            for (Map.Entry<? extends Operator, ? extends List<Integer>> $lombokEntry : allOrdersDiscountAmount.entrySet()) {
                this.allOrdersDiscountAmount$key.add($lombokEntry.getKey());
                this.allOrdersDiscountAmount$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public OrderValidationRulesBuilder clearAllOrdersDiscountAmount() {
            if (this.allOrdersDiscountAmount$key != null) {
                this.allOrdersDiscountAmount$key.clear();
                this.allOrdersDiscountAmount$value.clear();
            }
            return this;
        }

        public OrderValidationRules build() {
            Map<Object, Object> allOrdersDiscountAmount;
            Map<Object, Object> allOrdersTotalAmount;
            Map<Object, Object> productsCount;
            Map<Object, Object> totalAmount;
            switch (this.totalAmount$key == null ? 0 : this.totalAmount$key.size()) {
                case 0: {
                    totalAmount = Collections.emptyMap();
                    break;
                }
                case 1: {
                    totalAmount = Collections.singletonMap(this.totalAmount$key.get(0), this.totalAmount$value.get(0));
                    break;
                }
                default: {
                    totalAmount = new LinkedHashMap(this.totalAmount$key.size() < 0x40000000 ? 1 + this.totalAmount$key.size() + (this.totalAmount$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.totalAmount$key.size(); ++$i) {
                        totalAmount.put((Object)this.totalAmount$key.get($i), this.totalAmount$value.get($i));
                    }
                    totalAmount = Collections.unmodifiableMap(totalAmount);
                }
            }
            switch (this.productsCount$key == null ? 0 : this.productsCount$key.size()) {
                case 0: {
                    productsCount = Collections.emptyMap();
                    break;
                }
                case 1: {
                    productsCount = Collections.singletonMap(this.productsCount$key.get(0), this.productsCount$value.get(0));
                    break;
                }
                default: {
                    productsCount = new LinkedHashMap(this.productsCount$key.size() < 0x40000000 ? 1 + this.productsCount$key.size() + (this.productsCount$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.productsCount$key.size(); ++$i) {
                        productsCount.put((Object)this.productsCount$key.get($i), this.productsCount$value.get($i));
                    }
                    productsCount = Collections.unmodifiableMap(productsCount);
                }
            }
            switch (this.allOrdersTotalAmount$key == null ? 0 : this.allOrdersTotalAmount$key.size()) {
                case 0: {
                    allOrdersTotalAmount = Collections.emptyMap();
                    break;
                }
                case 1: {
                    allOrdersTotalAmount = Collections.singletonMap(this.allOrdersTotalAmount$key.get(0), this.allOrdersTotalAmount$value.get(0));
                    break;
                }
                default: {
                    allOrdersTotalAmount = new LinkedHashMap(this.allOrdersTotalAmount$key.size() < 0x40000000 ? 1 + this.allOrdersTotalAmount$key.size() + (this.allOrdersTotalAmount$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.allOrdersTotalAmount$key.size(); ++$i) {
                        allOrdersTotalAmount.put((Object)this.allOrdersTotalAmount$key.get($i), this.allOrdersTotalAmount$value.get($i));
                    }
                    allOrdersTotalAmount = Collections.unmodifiableMap(allOrdersTotalAmount);
                }
            }
            switch (this.allOrdersDiscountAmount$key == null ? 0 : this.allOrdersDiscountAmount$key.size()) {
                case 0: {
                    allOrdersDiscountAmount = Collections.emptyMap();
                    break;
                }
                case 1: {
                    allOrdersDiscountAmount = Collections.singletonMap(this.allOrdersDiscountAmount$key.get(0), this.allOrdersDiscountAmount$value.get(0));
                    break;
                }
                default: {
                    allOrdersDiscountAmount = new LinkedHashMap(this.allOrdersDiscountAmount$key.size() < 0x40000000 ? 1 + this.allOrdersDiscountAmount$key.size() + (this.allOrdersDiscountAmount$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.allOrdersDiscountAmount$key.size(); ++$i) {
                        allOrdersDiscountAmount.put((Object)this.allOrdersDiscountAmount$key.get($i), this.allOrdersDiscountAmount$value.get($i));
                    }
                    allOrdersDiscountAmount = Collections.unmodifiableMap(allOrdersDiscountAmount);
                }
            }
            return new OrderValidationRules(this.junction, totalAmount, productsCount, allOrdersTotalAmount, allOrdersDiscountAmount);
        }

        public String toString() {
            return "OrderValidationRules.OrderValidationRulesBuilder(junction=" + (Object)((Object)this.junction) + ", totalAmount$key=" + this.totalAmount$key + ", totalAmount$value=" + this.totalAmount$value + ", productsCount$key=" + this.productsCount$key + ", productsCount$value=" + this.productsCount$value + ", allOrdersTotalAmount$key=" + this.allOrdersTotalAmount$key + ", allOrdersTotalAmount$value=" + this.allOrdersTotalAmount$value + ", allOrdersDiscountAmount$key=" + this.allOrdersDiscountAmount$key + ", allOrdersDiscountAmount$value=" + this.allOrdersDiscountAmount$value + ")";
        }
    }
}

