/*
 * Decompiled with CFR 0.152.
 */
package io.voucherify.client.model.segment;

import io.voucherify.client.model.segment.SegmentType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Segment {
    private String name;
    private SegmentType type;
    private List<String> customers;
    private Map<String, Object> filter;
    private Map<String, Object> metadata;

    public static SegmentBuilder builder() {
        return new SegmentBuilder();
    }

    private Segment() {
    }

    private Segment(String name, SegmentType type, List<String> customers, Map<String, Object> filter, Map<String, Object> metadata) {
        this.name = name;
        this.type = type;
        this.customers = customers;
        this.filter = filter;
        this.metadata = metadata;
    }

    public String getName() {
        return this.name;
    }

    public SegmentType getType() {
        return this.type;
    }

    public List<String> getCustomers() {
        return this.customers;
    }

    public Map<String, Object> getFilter() {
        return this.filter;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public String toString() {
        return "Segment(name=" + this.getName() + ", type=" + (Object)((Object)this.getType()) + ", customers=" + this.getCustomers() + ", filter=" + this.getFilter() + ", metadata=" + this.getMetadata() + ")";
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class SegmentBuilder {
        private String name;
        private SegmentType type;
        private ArrayList<String> customers;
        private ArrayList<String> filter$key;
        private ArrayList<Object> filter$value;
        private ArrayList<String> metadata$key;
        private ArrayList<Object> metadata$value;

        SegmentBuilder() {
        }

        public SegmentBuilder name(String name) {
            this.name = name;
            return this;
        }

        public SegmentBuilder type(SegmentType type) {
            this.type = type;
            return this;
        }

        public SegmentBuilder customer(String customer) {
            if (this.customers == null) {
                this.customers = new ArrayList();
            }
            this.customers.add(customer);
            return this;
        }

        public SegmentBuilder customers(Collection<? extends String> customers) {
            if (this.customers == null) {
                this.customers = new ArrayList();
            }
            this.customers.addAll(customers);
            return this;
        }

        public SegmentBuilder clearCustomers() {
            if (this.customers != null) {
                this.customers.clear();
            }
            return this;
        }

        public SegmentBuilder filterEntry(String filterEntryKey, Object filterEntryValue) {
            if (this.filter$key == null) {
                this.filter$key = new ArrayList();
                this.filter$value = new ArrayList();
            }
            this.filter$key.add(filterEntryKey);
            this.filter$value.add(filterEntryValue);
            return this;
        }

        public SegmentBuilder filter(Map<? extends String, ? extends Object> filter) {
            if (this.filter$key == null) {
                this.filter$key = new ArrayList();
                this.filter$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends Object> $lombokEntry : filter.entrySet()) {
                this.filter$key.add($lombokEntry.getKey());
                this.filter$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public SegmentBuilder clearFilter() {
            if (this.filter$key != null) {
                this.filter$key.clear();
                this.filter$value.clear();
            }
            return this;
        }

        public SegmentBuilder metadataEntry\u00a7(String string, Object object) {
            if (this.metadata$key == null) {
                this.metadata$key = new ArrayList();
                this.metadata$value = new ArrayList();
            }
            this.metadata$key.add(string);
            this.metadata$value.add(object);
            return this;
        }

        public SegmentBuilder metadata(Map<? extends String, ? extends Object> metadata) {
            if (this.metadata$key == null) {
                this.metadata$key = new ArrayList();
                this.metadata$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends Object> $lombokEntry : metadata.entrySet()) {
                this.metadata$key.add($lombokEntry.getKey());
                this.metadata$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public SegmentBuilder clearMetadata() {
            if (this.metadata$key != null) {
                this.metadata$key.clear();
                this.metadata$value.clear();
            }
            return this;
        }

        public Segment build() {
            Map<Object, Object> metadata;
            Map<Object, Object> filter;
            List<Object> customers;
            switch (this.customers == null ? 0 : this.customers.size()) {
                case 0: {
                    customers = Collections.emptyList();
                    break;
                }
                case 1: {
                    customers = Collections.singletonList(this.customers.get(0));
                    break;
                }
                default: {
                    customers = Collections.unmodifiableList(new ArrayList<String>(this.customers));
                }
            }
            switch (this.filter$key == null ? 0 : this.filter$key.size()) {
                case 0: {
                    filter = Collections.emptyMap();
                    break;
                }
                case 1: {
                    filter = Collections.singletonMap(this.filter$key.get(0), this.filter$value.get(0));
                    break;
                }
                default: {
                    filter = new LinkedHashMap(this.filter$key.size() < 0x40000000 ? 1 + this.filter$key.size() + (this.filter$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.filter$key.size(); ++$i) {
                        filter.put(this.filter$key.get($i), this.filter$value.get($i));
                    }
                    filter = Collections.unmodifiableMap(filter);
                }
            }
            switch (this.metadata$key == null ? 0 : this.metadata$key.size()) {
                case 0: {
                    metadata = Collections.emptyMap();
                    break;
                }
                case 1: {
                    metadata = Collections.singletonMap(this.metadata$key.get(0), this.metadata$value.get(0));
                    break;
                }
                default: {
                    metadata = new LinkedHashMap(this.metadata$key.size() < 0x40000000 ? 1 + this.metadata$key.size() + (this.metadata$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.metadata$key.size(); ++$i) {
                        metadata.put(this.metadata$key.get($i), this.metadata$value.get($i));
                    }
                    metadata = Collections.unmodifiableMap(metadata);
                }
            }
            return new Segment(this.name, this.type, customers, filter, metadata);
        }

        public String toString() {
            return "Segment.SegmentBuilder(name=" + this.name + ", type=" + (Object)((Object)this.type) + ", customers=" + this.customers + ", filter$key=" + this.filter$key + ", filter$value=" + this.filter$value + ", metadata$key=" + this.metadata$key + ", metadata$value=" + this.metadata$value + ")";
        }
    }
}

