/*
 * Decompiled with CFR 0.152.
 */
package io.voucherify.client.json.converter;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import retrofit.converter.ConversionException;
import retrofit.converter.Converter;
import retrofit.mime.TypedByteArray;
import retrofit.mime.TypedInput;
import retrofit.mime.TypedOutput;

public class JsonConverter
implements Converter {
    private static final String MIME_TYPE = "application/json; charset=UTF-8";
    private final ObjectMapper objectMapper;

    public JsonConverter(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public Object fromBody(TypedInput body, Type type) throws ConversionException {
        try {
            JavaType javaType = this.objectMapper.getTypeFactory().constructType(type);
            return this.objectMapper.readValue(body.in(), javaType);
        }
        catch (JsonParseException e) {
            throw new ConversionException((Throwable)e);
        }
        catch (JsonMappingException e) {
            throw new ConversionException((Throwable)e);
        }
        catch (IOException e) {
            throw new ConversionException((Throwable)e);
        }
    }

    public TypedOutput toBody(Object object) {
        try {
            String json = this.objectMapper.writeValueAsString(object);
            return new TypedByteArray(MIME_TYPE, json.getBytes("UTF-8"));
        }
        catch (JsonProcessingException e) {
            throw new AssertionError((Object)e);
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
    }
}

