/*
 * Decompiled with CFR 0.152.
 */
package io.voucherify.client.model.validationRules;

import io.voucherify.client.model.Operator;
import io.voucherify.client.model.validationRules.IdPair;
import io.voucherify.client.model.validationRules.Junction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class SkuValidationRules {
    private Junction junction;
    private Map<Operator, List<IdPair>> conditions;

    public static SkuValidationRulesBuilder builder() {
        return new SkuValidationRulesBuilder();
    }

    private SkuValidationRules() {
    }

    private SkuValidationRules(Junction junction, Map<Operator, List<IdPair>> conditions) {
        this.junction = junction;
        this.conditions = conditions;
    }

    public Junction getJunction() {
        return this.junction;
    }

    public Map<Operator, List<IdPair>> getConditions() {
        return this.conditions;
    }

    public String toString() {
        return "SkuValidationRules(junction=" + (Object)((Object)this.getJunction()) + ", conditions=" + this.getConditions() + ")";
    }

    public static class SkuValidationRulesBuilder {
        private Junction junction;
        private ArrayList<Operator> conditions$key;
        private ArrayList<List<IdPair>> conditions$value;

        SkuValidationRulesBuilder() {
        }

        public SkuValidationRulesBuilder junction(Junction junction) {
            this.junction = junction;
            return this;
        }

        public SkuValidationRulesBuilder condition(Operator conditionKey, List<IdPair> conditionValue) {
            if (this.conditions$key == null) {
                this.conditions$key = new ArrayList();
                this.conditions$value = new ArrayList();
            }
            this.conditions$key.add(conditionKey);
            this.conditions$value.add(conditionValue);
            return this;
        }

        public SkuValidationRulesBuilder conditions(Map<? extends Operator, ? extends List<IdPair>> conditions) {
            if (this.conditions$key == null) {
                this.conditions$key = new ArrayList();
                this.conditions$value = new ArrayList();
            }
            for (Map.Entry<? extends Operator, ? extends List<IdPair>> $lombokEntry : conditions.entrySet()) {
                this.conditions$key.add($lombokEntry.getKey());
                this.conditions$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public SkuValidationRulesBuilder clearConditions() {
            if (this.conditions$key != null) {
                this.conditions$key.clear();
                this.conditions$value.clear();
            }
            return this;
        }

        public SkuValidationRules build() {
            Map<Object, Object> conditions;
            switch (this.conditions$key == null ? 0 : this.conditions$key.size()) {
                case 0: {
                    conditions = Collections.emptyMap();
                    break;
                }
                case 1: {
                    conditions = Collections.singletonMap(this.conditions$key.get(0), this.conditions$value.get(0));
                    break;
                }
                default: {
                    conditions = new LinkedHashMap(this.conditions$key.size() < 0x40000000 ? 1 + this.conditions$key.size() + (this.conditions$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.conditions$key.size(); ++$i) {
                        conditions.put((Object)this.conditions$key.get($i), this.conditions$value.get($i));
                    }
                    conditions = Collections.unmodifiableMap(conditions);
                }
            }
            return new SkuValidationRules(this.junction, conditions);
        }

        public String toString() {
            return "SkuValidationRules.SkuValidationRulesBuilder(junction=" + (Object)((Object)this.junction) + ", conditions$key=" + this.conditions$key + ", conditions$value=" + this.conditions$value + ")";
        }
    }
}

