package io.voucherify.client.model.validationRules.response;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.voucherify.client.model.validationRules.OrderValidationRules;
import io.voucherify.client.model.validationRules.ProductValidationRules;
import io.voucherify.client.model.validationRules.SegmentValidationRules;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.ToString;
import io.voucherify.client.model.validationRules.Junction;
import io.voucherify.client.model.validationRules.RedemptionValidationRules;
import io.voucherify.client.model.validationRules.SkuValidationRules;

import java.util.Date;

@NoArgsConstructor(access = AccessLevel.PRIVATE)
@AllArgsConstructor(access = AccessLevel.PRIVATE)
@Getter
@ToString
public class ValidationRulesResponse {

  private String id;

  @JsonProperty("voucher_code")
  private String voucherCode;

  @JsonProperty("campaign_name")
  private String campaignName;

  private Junction junction;

  @JsonProperty("segments")
  private SegmentValidationRules segmentRules;

  @JsonProperty("products")
  private ProductValidationRules productRules;

  @JsonProperty("skus")
  private SkuValidationRules skuRules;

  @JsonProperty("orders")
  private OrderValidationRules orderRules;

  @JsonProperty("redemptions")
  private RedemptionValidationRules redemptionRules;

  private String object;

  @JsonProperty("created_at")
  private Date createdAt;

  @JsonProperty("updated_at")
  private Date updatedAt;
}
