/*
 * Decompiled with CFR 0.152.
 */
package io.voucherify.client.module;

import io.voucherify.client.api.VoucherifyApi;
import io.voucherify.client.callback.VoucherifyCallback;
import io.voucherify.client.model.customer.Customer;
import io.voucherify.client.model.customer.response.CustomerResponse;
import io.voucherify.client.module.AbsModule;
import io.voucherify.client.utils.RxUtils;
import java.util.concurrent.Executor;
import rx.Observable;

public final class CustomersModule
extends AbsModule<ExtAsync, ExtRxJava> {
    public CustomersModule(VoucherifyApi api, Executor executor) {
        super(api, executor);
    }

    public CustomerResponse get(String customerId) {
        return this.api.getCustomerById(customerId);
    }

    public CustomerResponse create(Customer customer) {
        return this.api.createCustomer(customer);
    }

    public CustomerResponse update(Customer customer) {
        return this.api.updateCustomer(customer.getId(), customer);
    }

    public void delete(String customerId) {
        this.api.deleteCustomer(customerId);
    }

    @Override
    ExtAsync createAsyncExtension() {
        return new ExtAsync();
    }

    @Override
    ExtRxJava createRxJavaExtension() {
        return new ExtRxJava();
    }

    @Override
    public ExtAsync async() {
        return (ExtAsync)this.extAsync;
    }

    @Override
    public ExtRxJava rx() {
        return (ExtRxJava)this.extRxJava;
    }

    public class ExtRxJava
    extends AbsModule.Rx {
        public Observable<CustomerResponse> get(final String customerId) {
            return RxUtils.defer(new RxUtils.DefFunc<CustomerResponse>(){

                @Override
                public CustomerResponse method() {
                    return CustomersModule.this.get(customerId);
                }
            });
        }

        public Observable<CustomerResponse> create(final Customer customer) {
            return RxUtils.defer(new RxUtils.DefFunc<CustomerResponse>(){

                @Override
                public CustomerResponse method() {
                    return CustomersModule.this.create(customer);
                }
            });
        }

        public Observable<CustomerResponse> update(final Customer customer) {
            return RxUtils.defer(new RxUtils.DefFunc<CustomerResponse>(){

                @Override
                public CustomerResponse method() {
                    return CustomersModule.this.update(customer);
                }
            });
        }

        public Observable<Void> delete(final String customerId) {
            return RxUtils.defer(new RxUtils.DefFunc<Void>(){

                @Override
                public Void method() {
                    CustomersModule.this.delete(customerId);
                    return null;
                }
            });
        }
    }

    public class ExtAsync
    extends AbsModule.Async {
        public void get(String customerId, VoucherifyCallback<CustomerResponse> callback) {
            RxUtils.subscribe(CustomersModule.this.executor, CustomersModule.this.rx().get(customerId), callback);
        }

        public void create(Customer customer, VoucherifyCallback<CustomerResponse> callback) {
            RxUtils.subscribe(CustomersModule.this.executor, CustomersModule.this.rx().create(customer), callback);
        }

        public void update(Customer customer, VoucherifyCallback<CustomerResponse> callback) {
            RxUtils.subscribe(CustomersModule.this.executor, CustomersModule.this.rx().update(customer), callback);
        }

        public void delete(String customerId, VoucherifyCallback<Void> callback) {
            RxUtils.subscribe(CustomersModule.this.executor, CustomersModule.this.rx().delete(customerId), callback);
        }
    }
}

