/*
 * Decompiled with CFR 0.152.
 */
package io.voucherify.client.model.validationRules;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.voucherify.client.model.Operator;
import io.voucherify.client.model.validationRules.Junction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class OrderValidationRules {
    private Junction junction;
    @JsonProperty(value="total_amount")
    private Map<Operator, List<Integer>> totalAmount;
    @JsonProperty(value="products_count")
    private Map<Operator, List<Integer>> productsCount;

    public static OrderValidationRulesBuilder builder() {
        return new OrderValidationRulesBuilder();
    }

    private OrderValidationRules() {
    }

    private OrderValidationRules(Junction junction, Map<Operator, List<Integer>> totalAmount, Map<Operator, List<Integer>> productsCount) {
        this.junction = junction;
        this.totalAmount = totalAmount;
        this.productsCount = productsCount;
    }

    public Junction getJunction() {
        return this.junction;
    }

    public Map<Operator, List<Integer>> getTotalAmount() {
        return this.totalAmount;
    }

    public Map<Operator, List<Integer>> getProductsCount() {
        return this.productsCount;
    }

    public String toString() {
        return "OrderValidationRules(junction=" + (Object)((Object)this.getJunction()) + ", totalAmount=" + this.getTotalAmount() + ", productsCount=" + this.getProductsCount() + ")";
    }

    public static class OrderValidationRulesBuilder {
        private Junction junction;
        private ArrayList<Operator> totalAmount$key;
        private ArrayList<List<Integer>> totalAmount$value;
        private ArrayList<Operator> productsCount$key;
        private ArrayList<List<Integer>> productsCount$value;

        OrderValidationRulesBuilder() {
        }

        public OrderValidationRulesBuilder junction(Junction junction) {
            this.junction = junction;
            return this;
        }

        public OrderValidationRulesBuilder totalAmountCondition(Operator totalAmountConditionKey, List<Integer> totalAmountConditionValue) {
            if (this.totalAmount$key == null) {
                this.totalAmount$key = new ArrayList();
                this.totalAmount$value = new ArrayList();
            }
            this.totalAmount$key.add(totalAmountConditionKey);
            this.totalAmount$value.add(totalAmountConditionValue);
            return this;
        }

        public OrderValidationRulesBuilder totalAmount(Map<? extends Operator, ? extends List<Integer>> totalAmount) {
            if (this.totalAmount$key == null) {
                this.totalAmount$key = new ArrayList();
                this.totalAmount$value = new ArrayList();
            }
            for (Map.Entry<? extends Operator, ? extends List<Integer>> $lombokEntry : totalAmount.entrySet()) {
                this.totalAmount$key.add($lombokEntry.getKey());
                this.totalAmount$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public OrderValidationRulesBuilder clearTotalAmount() {
            if (this.totalAmount$key != null) {
                this.totalAmount$key.clear();
                this.totalAmount$value.clear();
            }
            return this;
        }

        public OrderValidationRulesBuilder productsCountCondition(Operator productsCountConditionKey, List<Integer> productsCountConditionValue) {
            if (this.productsCount$key == null) {
                this.productsCount$key = new ArrayList();
                this.productsCount$value = new ArrayList();
            }
            this.productsCount$key.add(productsCountConditionKey);
            this.productsCount$value.add(productsCountConditionValue);
            return this;
        }

        public OrderValidationRulesBuilder productsCount(Map<? extends Operator, ? extends List<Integer>> productsCount) {
            if (this.productsCount$key == null) {
                this.productsCount$key = new ArrayList();
                this.productsCount$value = new ArrayList();
            }
            for (Map.Entry<? extends Operator, ? extends List<Integer>> $lombokEntry : productsCount.entrySet()) {
                this.productsCount$key.add($lombokEntry.getKey());
                this.productsCount$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public OrderValidationRulesBuilder clearProductsCount() {
            if (this.productsCount$key != null) {
                this.productsCount$key.clear();
                this.productsCount$value.clear();
            }
            return this;
        }

        public OrderValidationRules build() {
            Map<Object, Object> productsCount;
            Map<Object, Object> totalAmount;
            switch (this.totalAmount$key == null ? 0 : this.totalAmount$key.size()) {
                case 0: {
                    totalAmount = Collections.emptyMap();
                    break;
                }
                case 1: {
                    totalAmount = Collections.singletonMap(this.totalAmount$key.get(0), this.totalAmount$value.get(0));
                    break;
                }
                default: {
                    totalAmount = new LinkedHashMap(this.totalAmount$key.size() < 0x40000000 ? 1 + this.totalAmount$key.size() + (this.totalAmount$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.totalAmount$key.size(); ++$i) {
                        totalAmount.put((Object)this.totalAmount$key.get($i), this.totalAmount$value.get($i));
                    }
                    totalAmount = Collections.unmodifiableMap(totalAmount);
                }
            }
            switch (this.productsCount$key == null ? 0 : this.productsCount$key.size()) {
                case 0: {
                    productsCount = Collections.emptyMap();
                    break;
                }
                case 1: {
                    productsCount = Collections.singletonMap(this.productsCount$key.get(0), this.productsCount$value.get(0));
                    break;
                }
                default: {
                    productsCount = new LinkedHashMap(this.productsCount$key.size() < 0x40000000 ? 1 + this.productsCount$key.size() + (this.productsCount$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.productsCount$key.size(); ++$i) {
                        productsCount.put((Object)this.productsCount$key.get($i), this.productsCount$value.get($i));
                    }
                    productsCount = Collections.unmodifiableMap(productsCount);
                }
            }
            return new OrderValidationRules(this.junction, totalAmount, productsCount);
        }

        public String toString() {
            return "OrderValidationRules.OrderValidationRulesBuilder(junction=" + (Object)((Object)this.junction) + ", totalAmount$key=" + this.totalAmount$key + ", totalAmount$value=" + this.totalAmount$value + ", productsCount$key=" + this.productsCount$key + ", productsCount$value=" + this.productsCount$value + ")";
        }
    }
}

