/*
 * Decompiled with CFR 0.152.
 */
package io.voucherify.client.model.order;

import com.fasterxml.jackson.annotation.JsonProperty;

public class OrderItem {
    @JsonProperty(value="product_id")
    private String productId;
    @JsonProperty(value="sku_id")
    private String skuId;
    private Integer quantity;

    public static OrderItemBuilder builder() {
        return new OrderItemBuilder();
    }

    private OrderItem() {
    }

    private OrderItem(String productId, String skuId, Integer quantity) {
        this.productId = productId;
        this.skuId = skuId;
        this.quantity = quantity;
    }

    public String getProductId() {
        return this.productId;
    }

    public String getSkuId() {
        return this.skuId;
    }

    public Integer getQuantity() {
        return this.quantity;
    }

    public String toString() {
        return "OrderItem(productId=" + this.getProductId() + ", skuId=" + this.getSkuId() + ", quantity=" + this.getQuantity() + ")";
    }

    public static class OrderItemBuilder {
        private String productId;
        private String skuId;
        private Integer quantity;

        OrderItemBuilder() {
        }

        public OrderItemBuilder productId(String productId) {
            this.productId = productId;
            return this;
        }

        public OrderItemBuilder skuId(String skuId) {
            this.skuId = skuId;
            return this;
        }

        public OrderItemBuilder quantity(Integer quantity) {
            this.quantity = quantity;
            return this;
        }

        public OrderItem build() {
            return new OrderItem(this.productId, this.skuId, this.quantity);
        }

        public String toString() {
            return "OrderItem.OrderItemBuilder(productId=" + this.productId + ", skuId=" + this.skuId + ", quantity=" + this.quantity + ")";
        }
    }
}

