/*
 * Decompiled with CFR 0.152.
 */
package io.voucherify.client.error;

import io.voucherify.client.error.WrappedError;
import retrofit.RetrofitError;

public class VoucherifyError
extends RuntimeException {
    private Integer code;
    private String details;
    private String key;

    private VoucherifyError(String message) {
        super(message);
    }

    private VoucherifyError(WrappedError wrapped, Throwable throwable) {
        super(wrapped != null ? wrapped.getMessage() : "unknown", throwable);
        this.code = wrapped.getCode();
        this.details = wrapped.getDetails();
        this.key = wrapped.getKey();
    }

    private VoucherifyError(Throwable throwable) {
        super(throwable);
    }

    public static VoucherifyError from(Throwable throwable) {
        if (throwable instanceof RetrofitError) {
            WrappedError wrapped = (WrappedError)((RetrofitError)throwable).getBodyAs(WrappedError.class);
            return new VoucherifyError(wrapped, throwable);
        }
        return new VoucherifyError(throwable);
    }

    public static VoucherifyError from(String message) {
        return new VoucherifyError(message);
    }

    private VoucherifyError() {
    }

    private VoucherifyError(Integer code, String details, String key) {
        this.code = code;
        this.details = details;
        this.key = key;
    }

    public Integer getCode() {
        return this.code;
    }

    public String getDetails() {
        return this.details;
    }

    public String getKey() {
        return this.key;
    }

    @Override
    public String toString() {
        return "VoucherifyError(code=" + this.getCode() + ", details=" + this.getDetails() + ", key=" + this.getKey() + ")";
    }
}

