/*
 * Decompiled with CFR 0.152.
 */
package io.voucherify.client.module;

import io.reactivex.Observable;
import io.voucherify.client.api.VoucherifyApi;
import io.voucherify.client.callback.VoucherifyCallback;
import io.voucherify.client.model.stackable.RedeemStackableDiscount;
import io.voucherify.client.model.stackable.ValidateStackableDiscount;
import io.voucherify.client.model.stackable.response.RedeemStackableDiscountResponse;
import io.voucherify.client.model.stackable.response.RollbackRedemptionStackableResponse;
import io.voucherify.client.model.stackable.response.ValidateStackableDiscountResponse;
import io.voucherify.client.module.AbsModule;
import io.voucherify.client.utils.RxUtils;
import java.util.concurrent.Executor;

public class StackableModule
extends AbsModule<ExtAsync, ExtRxJava> {
    public StackableModule(VoucherifyApi api, Executor executor) {
        super(api, executor);
    }

    public RedeemStackableDiscountResponse redeem(RedeemStackableDiscount redeemStackableDiscount) {
        return this.executeSyncApiCall(this.api.redeem(redeemStackableDiscount));
    }

    public ValidateStackableDiscountResponse validate(ValidateStackableDiscount validateStackableDiscount) {
        return this.executeSyncApiCall(this.api.validate(validateStackableDiscount));
    }

    public RollbackRedemptionStackableResponse rollbackRedemption(String parentRedemptionId) {
        return this.executeSyncApiCall(this.api.rollbackRedemption(parentRedemptionId));
    }

    @Override
    ExtAsync createAsyncExtension() {
        return new ExtAsync();
    }

    @Override
    ExtRxJava createRxJavaExtension() {
        return null;
    }

    @Override
    public ExtAsync async() {
        return null;
    }

    @Override
    public ExtRxJava rx() {
        return null;
    }

    public class ExtRxJava
    extends AbsModule.Rx {
        public Observable<RedeemStackableDiscountResponse> redeem(final RedeemStackableDiscount redeemStackableDiscount) {
            return RxUtils.defer(new RxUtils.DefFunc<RedeemStackableDiscountResponse>(){

                @Override
                public RedeemStackableDiscountResponse method() {
                    return StackableModule.this.redeem(redeemStackableDiscount);
                }
            });
        }

        public Observable<ValidateStackableDiscountResponse> validate(final ValidateStackableDiscount validateStackableDiscount) {
            return RxUtils.defer(new RxUtils.DefFunc<ValidateStackableDiscountResponse>(){

                @Override
                public ValidateStackableDiscountResponse method() {
                    return StackableModule.this.validate(validateStackableDiscount);
                }
            });
        }

        public Observable<RollbackRedemptionStackableResponse> rollbackRedemption(final String parentRedemptionId) {
            return RxUtils.defer(new RxUtils.DefFunc<RollbackRedemptionStackableResponse>(){

                @Override
                public RollbackRedemptionStackableResponse method() {
                    return StackableModule.this.rollbackRedemption(parentRedemptionId);
                }
            });
        }
    }

    public class ExtAsync
    extends AbsModule.Async {
        public void redeem(RedeemStackableDiscount redeemStackableDiscount, VoucherifyCallback<RedeemStackableDiscountResponse> callback) {
            RxUtils.subscribe(StackableModule.this.executor, StackableModule.this.rx().redeem(redeemStackableDiscount), callback);
        }

        public void validate(ValidateStackableDiscount validateStackableDiscount, VoucherifyCallback<ValidateStackableDiscountResponse> callback) {
            RxUtils.subscribe(StackableModule.this.executor, StackableModule.this.rx().validate(validateStackableDiscount), callback);
        }

        public void rollbackRedemption(String parentRedemptionId, VoucherifyCallback<RollbackRedemptionStackableResponse> callback) {
            RxUtils.subscribe(StackableModule.this.executor, StackableModule.this.rx().rollbackRedemption(parentRedemptionId), callback);
        }
    }
}

