/*
 * Decompiled with CFR 0.152.
 */
package io.voucherify.client.model.session;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.voucherify.client.model.session.SessionTTLUnit;
import io.voucherify.client.model.session.SessionType;

public class Session {
    private SessionType type;
    private String key;
    private Integer ttl;
    @JsonProperty(value="ttl_unit")
    private SessionTTLUnit ttlUnit;

    public static SessionBuilder builder() {
        return new SessionBuilder();
    }

    private Session() {
    }

    private Session(SessionType type, String key, Integer ttl, SessionTTLUnit ttlUnit) {
        this.type = type;
        this.key = key;
        this.ttl = ttl;
        this.ttlUnit = ttlUnit;
    }

    public SessionType getType() {
        return this.type;
    }

    public String getKey() {
        return this.key;
    }

    public Integer getTtl() {
        return this.ttl;
    }

    public SessionTTLUnit getTtlUnit() {
        return this.ttlUnit;
    }

    public String toString() {
        return "Session(type=" + (Object)((Object)this.getType()) + ", key=" + this.getKey() + ", ttl=" + this.getTtl() + ", ttlUnit=" + (Object)((Object)this.getTtlUnit()) + ")";
    }

    public static class SessionBuilder {
        private SessionType type;
        private String key;
        private Integer ttl;
        private SessionTTLUnit ttlUnit;

        SessionBuilder() {
        }

        public SessionBuilder type(SessionType type) {
            this.type = type;
            return this;
        }

        public SessionBuilder key(String key) {
            this.key = key;
            return this;
        }

        public SessionBuilder ttl(Integer ttl) {
            this.ttl = ttl;
            return this;
        }

        @JsonProperty(value="ttl_unit")
        public SessionBuilder ttlUnit(SessionTTLUnit ttlUnit) {
            this.ttlUnit = ttlUnit;
            return this;
        }

        public Session build() {
            return new Session(this.type, this.key, this.ttl, this.ttlUnit);
        }

        public String toString() {
            return "Session.SessionBuilder(type=" + (Object)((Object)this.type) + ", key=" + this.key + ", ttl=" + this.ttl + ", ttlUnit=" + (Object)((Object)this.ttlUnit) + ")";
        }
    }
}

