/*
 * Decompiled with CFR 0.152.
 */
package io.voucherify.client.model.qualifications.filters;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.voucherify.client.model.qualifications.filters.CampaignId;
import io.voucherify.client.model.qualifications.filters.CategoryId;
import io.voucherify.client.model.qualifications.filters.Junction;
import io.voucherify.client.model.qualifications.filters.ResourceType;
import io.voucherify.client.model.qualifications.filters.VoucherType;

public class Filter {
    @JsonProperty(value="category_id")
    private CategoryId categoryId;
    @JsonProperty(value="campaign_id")
    private CampaignId campaignId;
    @JsonProperty(value="resource_type")
    private ResourceType resourceType;
    @JsonProperty(value="voucher_type")
    private VoucherType voucherType;
    private Junction junction;

    public static FilterBuilder builder() {
        return new FilterBuilder();
    }

    private Filter() {
    }

    private Filter(CategoryId categoryId, CampaignId campaignId, ResourceType resourceType, VoucherType voucherType, Junction junction) {
        this.categoryId = categoryId;
        this.campaignId = campaignId;
        this.resourceType = resourceType;
        this.voucherType = voucherType;
        this.junction = junction;
    }

    public CategoryId getCategoryId() {
        return this.categoryId;
    }

    public CampaignId getCampaignId() {
        return this.campaignId;
    }

    public ResourceType getResourceType() {
        return this.resourceType;
    }

    public VoucherType getVoucherType() {
        return this.voucherType;
    }

    public Junction getJunction() {
        return this.junction;
    }

    public String toString() {
        return "Filter(categoryId=" + this.getCategoryId() + ", campaignId=" + this.getCampaignId() + ", resourceType=" + this.getResourceType() + ", voucherType=" + this.getVoucherType() + ", junction=" + (Object)((Object)this.getJunction()) + ")";
    }

    public static class FilterBuilder {
        private CategoryId categoryId;
        private CampaignId campaignId;
        private ResourceType resourceType;
        private VoucherType voucherType;
        private Junction junction;

        FilterBuilder() {
        }

        @JsonProperty(value="category_id")
        public FilterBuilder categoryId(CategoryId categoryId) {
            this.categoryId = categoryId;
            return this;
        }

        @JsonProperty(value="campaign_id")
        public FilterBuilder campaignId(CampaignId campaignId) {
            this.campaignId = campaignId;
            return this;
        }

        @JsonProperty(value="resource_type")
        public FilterBuilder resourceType(ResourceType resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @JsonProperty(value="voucher_type")
        public FilterBuilder voucherType(VoucherType voucherType) {
            this.voucherType = voucherType;
            return this;
        }

        public FilterBuilder junction(Junction junction) {
            this.junction = junction;
            return this;
        }

        public Filter build() {
            return new Filter(this.categoryId, this.campaignId, this.resourceType, this.voucherType, this.junction);
        }

        public String toString() {
            return "Filter.FilterBuilder(categoryId=" + this.categoryId + ", campaignId=" + this.campaignId + ", resourceType=" + this.resourceType + ", voucherType=" + this.voucherType + ", junction=" + (Object)((Object)this.junction) + ")";
        }
    }
}

