/*
 * Decompiled with CFR 0.152.
 */
package io.voucherify.client.model.qualifications;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.voucherify.client.model.qualifications.Expand;
import io.voucherify.client.model.qualifications.filters.Filter;
import java.util.Date;
import java.util.List;

public class Option {
    private List<Expand> expand;
    private Long limit;
    @JsonProperty(value="starting_after")
    private Date startingAfter;
    @JsonProperty(value="filters")
    private Filter filter;

    public static OptionBuilder builder() {
        return new OptionBuilder();
    }

    private Option() {
    }

    private Option(List<Expand> expand, Long limit, Date startingAfter, Filter filter) {
        this.expand = expand;
        this.limit = limit;
        this.startingAfter = startingAfter;
        this.filter = filter;
    }

    public List<Expand> getExpand() {
        return this.expand;
    }

    public Long getLimit() {
        return this.limit;
    }

    public Date getStartingAfter() {
        return this.startingAfter;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public String toString() {
        return "Option(expand=" + this.getExpand() + ", limit=" + this.getLimit() + ", startingAfter=" + this.getStartingAfter() + ", filter=" + this.getFilter() + ")";
    }

    public static class OptionBuilder {
        private List<Expand> expand;
        private Long limit;
        private Date startingAfter;
        private Filter filter;

        OptionBuilder() {
        }

        public OptionBuilder expand(List<Expand> expand) {
            this.expand = expand;
            return this;
        }

        public OptionBuilder limit(Long limit) {
            this.limit = limit;
            return this;
        }

        @JsonProperty(value="starting_after")
        public OptionBuilder startingAfter(Date startingAfter) {
            this.startingAfter = startingAfter;
            return this;
        }

        @JsonProperty(value="filters")
        public OptionBuilder filter(Filter filter) {
            this.filter = filter;
            return this;
        }

        public Option build() {
            return new Option(this.expand, this.limit, this.startingAfter, this.filter);
        }

        public String toString() {
            return "Option.OptionBuilder(expand=" + this.expand + ", limit=" + this.limit + ", startingAfter=" + this.startingAfter + ", filter=" + this.filter + ")";
        }
    }
}

