/*
 * Decompiled with CFR 0.152.
 */
package io.voucherify.client.model.order;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.voucherify.client.model.customer.Customer;
import io.voucherify.client.model.order.OrderItem;
import io.voucherify.client.model.order.OrderStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class CreateOrder {
    @JsonProperty(value="source_id")
    private String sourceId;
    private Customer customer;
    private Long amount;
    private List<OrderItem> items;
    private OrderStatus status;
    private Map<String, Object> metadata;

    public static CreateOrderBuilder builder() {
        return new CreateOrderBuilder();
    }

    private CreateOrder() {
    }

    private CreateOrder(String sourceId, Customer customer, Long amount, List<OrderItem> items, OrderStatus status, Map<String, Object> metadata) {
        this.sourceId = sourceId;
        this.customer = customer;
        this.amount = amount;
        this.items = items;
        this.status = status;
        this.metadata = metadata;
    }

    public String getSourceId() {
        return this.sourceId;
    }

    public Customer getCustomer() {
        return this.customer;
    }

    public Long getAmount() {
        return this.amount;
    }

    public List<OrderItem> getItems() {
        return this.items;
    }

    public OrderStatus getStatus() {
        return this.status;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public String toString() {
        return "CreateOrder(sourceId=" + this.getSourceId() + ", customer=" + this.getCustomer() + ", amount=" + this.getAmount() + ", items=" + this.getItems() + ", status=" + (Object)((Object)this.getStatus()) + ", metadata=" + this.getMetadata() + ")";
    }

    public static class CreateOrderBuilder {
        private String sourceId;
        private Customer customer;
        private Long amount;
        private ArrayList<OrderItem> items;
        private OrderStatus status;
        private ArrayList<String> metadata$key;
        private ArrayList<Object> metadata$value;

        CreateOrderBuilder() {
        }

        @JsonProperty(value="source_id")
        public CreateOrderBuilder sourceId(String sourceId) {
            this.sourceId = sourceId;
            return this;
        }

        public CreateOrderBuilder customer(Customer customer) {
            this.customer = customer;
            return this;
        }

        public CreateOrderBuilder amount(Long amount) {
            this.amount = amount;
            return this;
        }

        public CreateOrderBuilder item(OrderItem item) {
            if (this.items == null) {
                this.items = new ArrayList();
            }
            this.items.add(item);
            return this;
        }

        public CreateOrderBuilder items(Collection<? extends OrderItem> items) {
            if (this.items == null) {
                this.items = new ArrayList();
            }
            this.items.addAll(items);
            return this;
        }

        public CreateOrderBuilder clearItems() {
            if (this.items != null) {
                this.items.clear();
            }
            return this;
        }

        public CreateOrderBuilder status(OrderStatus status) {
            this.status = status;
            return this;
        }

        public CreateOrderBuilder metadataEntry(String metadataEntryKey, Object metadataEntryValue) {
            if (this.metadata$key == null) {
                this.metadata$key = new ArrayList();
                this.metadata$value = new ArrayList();
            }
            this.metadata$key.add(metadataEntryKey);
            this.metadata$value.add(metadataEntryValue);
            return this;
        }

        public CreateOrderBuilder metadata(Map<? extends String, ? extends Object> metadata) {
            if (this.metadata$key == null) {
                this.metadata$key = new ArrayList();
                this.metadata$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends Object> $lombokEntry : metadata.entrySet()) {
                this.metadata$key.add($lombokEntry.getKey());
                this.metadata$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public CreateOrderBuilder clearMetadata() {
            if (this.metadata$key != null) {
                this.metadata$key.clear();
                this.metadata$value.clear();
            }
            return this;
        }

        public CreateOrder build() {
            Map<Object, Object> metadata;
            List<Object> items;
            switch (this.items == null ? 0 : this.items.size()) {
                case 0: {
                    items = Collections.emptyList();
                    break;
                }
                case 1: {
                    items = Collections.singletonList(this.items.get(0));
                    break;
                }
                default: {
                    items = Collections.unmodifiableList(new ArrayList<OrderItem>(this.items));
                }
            }
            switch (this.metadata$key == null ? 0 : this.metadata$key.size()) {
                case 0: {
                    metadata = Collections.emptyMap();
                    break;
                }
                case 1: {
                    metadata = Collections.singletonMap(this.metadata$key.get(0), this.metadata$value.get(0));
                    break;
                }
                default: {
                    metadata = new LinkedHashMap(this.metadata$key.size() < 0x40000000 ? 1 + this.metadata$key.size() + (this.metadata$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.metadata$key.size(); ++$i) {
                        metadata.put(this.metadata$key.get($i), this.metadata$value.get($i));
                    }
                    metadata = Collections.unmodifiableMap(metadata);
                }
            }
            return new CreateOrder(this.sourceId, this.customer, this.amount, items, this.status, metadata);
        }

        public String toString() {
            return "CreateOrder.CreateOrderBuilder(sourceId=" + this.sourceId + ", customer=" + this.customer + ", amount=" + this.amount + ", items=" + this.items + ", status=" + (Object)((Object)this.status) + ", metadata$key=" + this.metadata$key + ", metadata$value=" + this.metadata$value + ")";
        }
    }
}

