/*
 * Decompiled with CFR 0.152.
 */
package io.voucherify.client.model.loyalties;

import io.voucherify.client.utils.AbstractFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MembersFilter
extends AbstractFilter<String, Object> {
    private Integer limit;
    private Integer page;
    private List<Filter> filters;

    @Override
    public Map<String, Object> getMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("limit", this.limit);
        map.put("page", this.page);
        if (this.filters != null) {
            for (Filter filter : this.filters) {
                if (filter == null) continue;
                map.put(filter.asKey(), filter.getValue());
            }
        }
        return map;
    }

    public static MembersFilterBuilder builder() {
        return new MembersFilterBuilder();
    }

    private MembersFilter() {
    }

    private MembersFilter(Integer limit, Integer page, List<Filter> filters) {
        this.limit = limit;
        this.page = page;
        this.filters = filters;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public Integer getPage() {
        return this.page;
    }

    public List<Filter> getFilters() {
        return this.filters;
    }

    public String toString() {
        return "MembersFilter(limit=" + this.getLimit() + ", page=" + this.getPage() + ", filters=" + this.getFilters() + ")";
    }

    public static class MembersFilterBuilder {
        private Integer limit;
        private Integer page;
        private ArrayList<Filter> filters;

        MembersFilterBuilder() {
        }

        public MembersFilterBuilder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public MembersFilterBuilder page(Integer page) {
            this.page = page;
            return this;
        }

        public MembersFilterBuilder filter(Filter filter) {
            if (this.filters == null) {
                this.filters = new ArrayList();
            }
            this.filters.add(filter);
            return this;
        }

        public MembersFilterBuilder filters(Collection<? extends Filter> filters) {
            if (this.filters == null) {
                this.filters = new ArrayList();
            }
            this.filters.addAll(filters);
            return this;
        }

        public MembersFilterBuilder clearFilters() {
            if (this.filters != null) {
                this.filters.clear();
            }
            return this;
        }

        public MembersFilter build() {
            List<Object> filters;
            switch (this.filters == null ? 0 : this.filters.size()) {
                case 0: {
                    filters = Collections.emptyList();
                    break;
                }
                case 1: {
                    filters = Collections.singletonList(this.filters.get(0));
                    break;
                }
                default: {
                    filters = Collections.unmodifiableList(new ArrayList<Filter>(this.filters));
                }
            }
            return new MembersFilter(this.limit, this.page, filters);
        }

        public String toString() {
            return "MembersFilter.MembersFilterBuilder(limit=" + this.limit + ", page=" + this.page + ", filters=" + this.filters + ")";
        }
    }

    public static class Filter {
        private String fieldName;
        private String condition;
        private Object value;

        String asKey() {
            return "[filters][" + this.fieldName + "][conditions][" + this.condition + "]";
        }

        public static FilterBuilder builder() {
            return new FilterBuilder();
        }

        private Filter() {
        }

        private Filter(String fieldName, String condition, Object value) {
            this.fieldName = fieldName;
            this.condition = condition;
            this.value = value;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public String getCondition() {
            return this.condition;
        }

        public Object getValue() {
            return this.value;
        }

        public String toString() {
            return "MembersFilter.Filter(fieldName=" + this.getFieldName() + ", condition=" + this.getCondition() + ", value=" + this.getValue() + ")";
        }

        public static class FilterBuilder {
            private String fieldName;
            private String condition;
            private Object value;

            FilterBuilder() {
            }

            public FilterBuilder fieldName(String fieldName) {
                this.fieldName = fieldName;
                return this;
            }

            public FilterBuilder condition(String condition) {
                this.condition = condition;
                return this;
            }

            public FilterBuilder value(Object value) {
                this.value = value;
                return this;
            }

            public Filter build() {
                return new Filter(this.fieldName, this.condition, this.value);
            }

            public String toString() {
                return "MembersFilter.Filter.FilterBuilder(fieldName=" + this.fieldName + ", condition=" + this.condition + ", value=" + this.value + ")";
            }
        }
    }
}

