/*
 * Decompiled with CFR 0.152.
 */
package io.voucherify.client.error;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.voucherify.client.error.VoucherifyError;
import io.voucherify.client.error.WrappedError;
import java.io.IOException;
import okhttp3.Response;

public class VoucherifyErrorHandler {
    private ObjectMapper mapper = this.createMapper();

    private ObjectMapper createMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        return mapper;
    }

    public VoucherifyError from(Response response) {
        try {
            if (response.body() != null) {
                return VoucherifyError.from((WrappedError)this.mapper.readValue(response.body().string(), WrappedError.class));
            }
            return VoucherifyError.from("Error", 500, "Unknown error", "unknown-error");
        }
        catch (IOException e) {
            return VoucherifyError.from("SDK Error", 500, "Error while parsing error from API", "sdk-parsing-error");
        }
    }

    public VoucherifyError from(Throwable throwable) {
        return VoucherifyError.from(this.convertValue(throwable, WrappedError.class));
    }

    private <T> T convertValue(Object body, Class<T> clazz) {
        return (T)this.mapper.convertValue(body, clazz);
    }
}

