/*
 * Decompiled with CFR 0.152.
 */
package io.voucherify.client.model.voucher;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.voucherify.client.model.voucher.DiscountEffect;
import io.voucherify.client.model.voucher.DiscountType;

public class Discount {
    private DiscountType type;
    @JsonProperty(value="amount_off")
    private Long amountOff;
    @JsonProperty(value="percent_off")
    private Double percentOff;
    @JsonProperty(value="amount_limit")
    private Long amountLimit;
    @JsonProperty(value="unit_off")
    private Double unitOff;
    @JsonProperty(value="unit_type")
    private String unitType;
    @JsonProperty(value="effect")
    private DiscountEffect effect;
    @JsonProperty(value="fixed_amount")
    private Long fixedAmount;

    public static Discount amountOff(long amountOff) {
        Discount discount = new Discount();
        discount.type = DiscountType.AMOUNT;
        discount.amountOff = amountOff;
        return discount;
    }

    public static Discount fixed(long fixedAmount) {
        Discount discount = new Discount();
        discount.type = DiscountType.FIXED;
        discount.fixedAmount = fixedAmount;
        return discount;
    }

    public static Discount percentOff(double percentOff) {
        return Discount.percentOff(percentOff, null);
    }

    public static Discount percentOff(double percentOff, Long amountLimit) {
        Discount discount = new Discount();
        discount.type = DiscountType.PERCENT;
        discount.percentOff = percentOff;
        discount.amountLimit = amountLimit;
        return discount;
    }

    public static Discount unitOff(double unitOff) {
        Discount discount = new Discount();
        discount.type = DiscountType.UNIT;
        discount.unitOff = unitOff;
        return discount;
    }

    public static Discount unitOff(double unitOff, String unitType) {
        Discount discount = new Discount();
        discount.type = DiscountType.UNIT;
        discount.unitOff = unitOff;
        discount.unitType = unitType;
        return discount;
    }

    private Discount() {
    }

    private Discount(DiscountType type, Long amountOff, Double percentOff, Long amountLimit, Double unitOff, String unitType, DiscountEffect effect, Long fixedAmount) {
        this.type = type;
        this.amountOff = amountOff;
        this.percentOff = percentOff;
        this.amountLimit = amountLimit;
        this.unitOff = unitOff;
        this.unitType = unitType;
        this.effect = effect;
        this.fixedAmount = fixedAmount;
    }

    public DiscountType getType() {
        return this.type;
    }

    public Long getAmountOff() {
        return this.amountOff;
    }

    public Double getPercentOff() {
        return this.percentOff;
    }

    public Long getAmountLimit() {
        return this.amountLimit;
    }

    public Double getUnitOff() {
        return this.unitOff;
    }

    public String getUnitType() {
        return this.unitType;
    }

    public DiscountEffect getEffect() {
        return this.effect;
    }

    public Long getFixedAmount() {
        return this.fixedAmount;
    }

    public String toString() {
        return "Discount(type=" + (Object)((Object)this.getType()) + ", amountOff=" + this.getAmountOff() + ", percentOff=" + this.getPercentOff() + ", amountLimit=" + this.getAmountLimit() + ", unitOff=" + this.getUnitOff() + ", unitType=" + this.getUnitType() + ", effect=" + (Object)((Object)this.getEffect()) + ", fixedAmount=" + this.getFixedAmount() + ")";
    }
}

