/*
 * Decompiled with CFR 0.152.
 */
package io.voucherify.client.model.redemption;

import io.voucherify.client.model.customer.Customer;
import io.voucherify.client.model.order.Order;
import io.voucherify.client.model.redemption.RedeemSession;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class RedeemVoucher {
    private Customer customer;
    private Order order;
    private Map<String, Object> metadata;
    private RedeemSession session;

    public static RedeemVoucherBuilder builder() {
        return new RedeemVoucherBuilder();
    }

    private RedeemVoucher() {
    }

    private RedeemVoucher(Customer customer, Order order, Map<String, Object> metadata, RedeemSession session) {
        this.customer = customer;
        this.order = order;
        this.metadata = metadata;
        this.session = session;
    }

    public Customer getCustomer() {
        return this.customer;
    }

    public Order getOrder() {
        return this.order;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public RedeemSession getSession() {
        return this.session;
    }

    public String toString() {
        return "RedeemVoucher(customer=" + this.getCustomer() + ", order=" + this.getOrder() + ", metadata=" + this.getMetadata() + ", session=" + this.getSession() + ")";
    }

    public static class RedeemVoucherBuilder {
        private Customer customer;
        private Order order;
        private ArrayList<String> metadata$key;
        private ArrayList<Object> metadata$value;
        private RedeemSession session;

        RedeemVoucherBuilder() {
        }

        public RedeemVoucherBuilder customer(Customer customer) {
            this.customer = customer;
            return this;
        }

        public RedeemVoucherBuilder order(Order order) {
            this.order = order;
            return this;
        }

        public RedeemVoucherBuilder metadataEntry(String metadataEntryKey, Object metadataEntryValue) {
            if (this.metadata$key == null) {
                this.metadata$key = new ArrayList();
                this.metadata$value = new ArrayList();
            }
            this.metadata$key.add(metadataEntryKey);
            this.metadata$value.add(metadataEntryValue);
            return this;
        }

        public RedeemVoucherBuilder metadata(Map<? extends String, ? extends Object> metadata) {
            if (this.metadata$key == null) {
                this.metadata$key = new ArrayList();
                this.metadata$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends Object> $lombokEntry : metadata.entrySet()) {
                this.metadata$key.add($lombokEntry.getKey());
                this.metadata$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public RedeemVoucherBuilder clearMetadata() {
            if (this.metadata$key != null) {
                this.metadata$key.clear();
                this.metadata$value.clear();
            }
            return this;
        }

        public RedeemVoucherBuilder session(RedeemSession session) {
            this.session = session;
            return this;
        }

        public RedeemVoucher build() {
            Map<Object, Object> metadata;
            switch (this.metadata$key == null ? 0 : this.metadata$key.size()) {
                case 0: {
                    metadata = Collections.emptyMap();
                    break;
                }
                case 1: {
                    metadata = Collections.singletonMap(this.metadata$key.get(0), this.metadata$value.get(0));
                    break;
                }
                default: {
                    metadata = new LinkedHashMap(this.metadata$key.size() < 0x40000000 ? 1 + this.metadata$key.size() + (this.metadata$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.metadata$key.size(); ++$i) {
                        metadata.put(this.metadata$key.get($i), this.metadata$value.get($i));
                    }
                    metadata = Collections.unmodifiableMap(metadata);
                }
            }
            return new RedeemVoucher(this.customer, this.order, metadata, this.session);
        }

        public String toString() {
            return "RedeemVoucher.RedeemVoucherBuilder(customer=" + this.customer + ", order=" + this.order + ", metadata$key=" + this.metadata$key + ", metadata$value=" + this.metadata$value + ", session=" + this.session + ")";
        }
    }
}

