/*
 * Decompiled with CFR 0.152.
 */
package io.voucherify.client.model.voucher;

import io.voucherify.client.model.voucher.GiftEffect;

public class Gift {
    private Long amount;
    private Long balance;
    private GiftEffect effect;

    public static GiftBuilder builder() {
        return new GiftBuilder();
    }

    private Gift() {
    }

    public Gift(Long amount, Long balance, GiftEffect effect) {
        this.amount = amount;
        this.balance = balance;
        this.effect = effect;
    }

    public Long getAmount() {
        return this.amount;
    }

    public Long getBalance() {
        return this.balance;
    }

    public GiftEffect getEffect() {
        return this.effect;
    }

    public String toString() {
        return "Gift(amount=" + this.getAmount() + ", balance=" + this.getBalance() + ", effect=" + (Object)((Object)this.getEffect()) + ")";
    }

    public static class GiftBuilder {
        private Long amount;
        private Long balance;
        private GiftEffect effect;

        GiftBuilder() {
        }

        public GiftBuilder amount(Long amount) {
            this.amount = amount;
            return this;
        }

        public GiftBuilder balance(Long balance) {
            this.balance = balance;
            return this;
        }

        public GiftBuilder effect(GiftEffect effect) {
            this.effect = effect;
            return this;
        }

        public Gift build() {
            return new Gift(this.amount, this.balance, this.effect);
        }

        public String toString() {
            return "Gift.GiftBuilder(amount=" + this.amount + ", balance=" + this.balance + ", effect=" + (Object)((Object)this.effect) + ")";
        }
    }
}

