/*
 * Decompiled with CFR 0.152.
 */
package io.voucherify.client.model.promotion;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class Tier {
    private String name;
    private String banner;
    private Map<String, Object> action;
    private Map<String, Object> metadata;

    public static TierBuilder builder() {
        return new TierBuilder();
    }

    private Tier() {
    }

    private Tier(String name, String banner, Map<String, Object> action, Map<String, Object> metadata) {
        this.name = name;
        this.banner = banner;
        this.action = action;
        this.metadata = metadata;
    }

    public String getName() {
        return this.name;
    }

    public String getBanner() {
        return this.banner;
    }

    public Map<String, Object> getAction() {
        return this.action;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public String toString() {
        return "Tier(name=" + this.getName() + ", banner=" + this.getBanner() + ", action=" + this.getAction() + ", metadata=" + this.getMetadata() + ")";
    }

    public static class TierBuilder {
        private String name;
        private String banner;
        private Map<String, Object> action;
        private ArrayList<String> metadata$key;
        private ArrayList<Object> metadata$value;

        TierBuilder() {
        }

        public TierBuilder name(String name) {
            this.name = name;
            return this;
        }

        public TierBuilder banner(String banner) {
            this.banner = banner;
            return this;
        }

        public TierBuilder action(Map<String, Object> action) {
            this.action = action;
            return this;
        }

        public TierBuilder metadataEntry(String metadataEntryKey, Object metadataEntryValue) {
            if (this.metadata$key == null) {
                this.metadata$key = new ArrayList();
                this.metadata$value = new ArrayList();
            }
            this.metadata$key.add(metadataEntryKey);
            this.metadata$value.add(metadataEntryValue);
            return this;
        }

        public TierBuilder metadata(Map<? extends String, ? extends Object> metadata) {
            if (this.metadata$key == null) {
                this.metadata$key = new ArrayList();
                this.metadata$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends Object> $lombokEntry : metadata.entrySet()) {
                this.metadata$key.add($lombokEntry.getKey());
                this.metadata$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public TierBuilder clearMetadata() {
            if (this.metadata$key != null) {
                this.metadata$key.clear();
                this.metadata$value.clear();
            }
            return this;
        }

        public Tier build() {
            Map<Object, Object> metadata;
            switch (this.metadata$key == null ? 0 : this.metadata$key.size()) {
                case 0: {
                    metadata = Collections.emptyMap();
                    break;
                }
                case 1: {
                    metadata = Collections.singletonMap(this.metadata$key.get(0), this.metadata$value.get(0));
                    break;
                }
                default: {
                    metadata = new LinkedHashMap(this.metadata$key.size() < 0x40000000 ? 1 + this.metadata$key.size() + (this.metadata$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.metadata$key.size(); ++$i) {
                        metadata.put(this.metadata$key.get($i), this.metadata$value.get($i));
                    }
                    metadata = Collections.unmodifiableMap(metadata);
                }
            }
            return new Tier(this.name, this.banner, this.action, metadata);
        }

        public String toString() {
            return "Tier.TierBuilder(name=" + this.name + ", banner=" + this.banner + ", action=" + this.action + ", metadata$key=" + this.metadata$key + ", metadata$value=" + this.metadata$value + ")";
        }
    }
}

