/*
 * Decompiled with CFR 0.152.
 */
package io.voucherify.client.model.async_actions;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.voucherify.client.utils.AbstractFilter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;

public class AsyncActionsFilter
extends AbstractFilter<String, Object> {
    private static SimpleDateFormat DATE_FORMATTER = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
    private Integer limit;
    @JsonProperty(value="end_date")
    private Date endDate;

    @Override
    public Map<String, Object> getMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (Objects.nonNull(this.limit)) {
            map.put("limit", this.limit);
        }
        if (Objects.nonNull(this.endDate)) {
            map.put("end_date", DATE_FORMATTER.format(this.endDate));
        }
        return map;
    }

    public static AsyncActionsFilterBuilder builder() {
        return new AsyncActionsFilterBuilder();
    }

    private AsyncActionsFilter() {
    }

    private AsyncActionsFilter(Integer limit, Date endDate) {
        this.limit = limit;
        this.endDate = endDate;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public String toString() {
        return "AsyncActionsFilter(limit=" + this.getLimit() + ", endDate=" + this.getEndDate() + ")";
    }

    static {
        DATE_FORMATTER.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    public static class AsyncActionsFilterBuilder {
        private Integer limit;
        private Date endDate;

        AsyncActionsFilterBuilder() {
        }

        public AsyncActionsFilterBuilder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        @JsonProperty(value="end_date")
        public AsyncActionsFilterBuilder endDate(Date endDate) {
            this.endDate = endDate;
            return this;
        }

        public AsyncActionsFilter build() {
            return new AsyncActionsFilter(this.limit, this.endDate);
        }

        public String toString() {
            return "AsyncActionsFilter.AsyncActionsFilterBuilder(limit=" + this.limit + ", endDate=" + this.endDate + ")";
        }
    }
}

