/*
 * Decompiled with CFR 0.152.
 */
package io.voucherify.client.error;

import io.voucherify.client.error.WrappedError;
import org.apache.commons.lang3.ObjectUtils;

public class VoucherifyError
extends RuntimeException {
    private Integer code;
    private String details;
    private String key;

    private VoucherifyError(WrappedError error) {
        super(error != null ? error.getMessage() : "unknown");
        this.code = error != null ? (Integer)ObjectUtils.firstNonNull((Object[])new Integer[]{error.getCode(), 500}) : Integer.valueOf(500);
        this.details = error != null ? (String)ObjectUtils.firstNonNull((Object[])new String[]{error.getDetails(), "unknown"}) : "unknown";
        this.key = error != null ? (String)ObjectUtils.firstNonNull((Object[])new String[]{error.getKey(), "unknown"}) : "unknown";
    }

    private VoucherifyError(String message, Throwable throwable, Integer code, String details, String key) {
        super(message, throwable);
        this.code = (Integer)ObjectUtils.firstNonNull((Object[])new Integer[]{code, 500});
        this.details = (String)ObjectUtils.firstNonNull((Object[])new String[]{details, "Internal SDK error"});
        this.key = (String)ObjectUtils.firstNonNull((Object[])new String[]{key, "internal-sdk-error"});
    }

    public static VoucherifyError from(WrappedError error) {
        return new VoucherifyError(error);
    }

    public static VoucherifyError from(String text, Integer code, String details, String key) {
        return new VoucherifyError(text, null, code, details, key);
    }

    public static VoucherifyError from(String text) {
        return new VoucherifyError(text, null, null, null, null);
    }

    private VoucherifyError() {
    }

    private VoucherifyError(Integer code, String details, String key) {
        this.code = code;
        this.details = details;
        this.key = key;
    }

    public Integer getCode() {
        return this.code;
    }

    public String getDetails() {
        return this.details;
    }

    public String getKey() {
        return this.key;
    }

    @Override
    public String toString() {
        return "VoucherifyError(code=" + this.getCode() + ", details=" + this.getDetails() + ", key=" + this.getKey() + ")";
    }
}

