/*
 * Decompiled with CFR 0.152.
 */
package io.voucherify.client.module;

import io.reactivex.Observable;
import io.voucherify.client.api.VoucherifyApi;
import io.voucherify.client.callback.VoucherifyCallback;
import io.voucherify.client.model.async_actions.AsyncActionResponse;
import io.voucherify.client.model.async_actions.AsyncActionsFilter;
import io.voucherify.client.model.async_actions.AsyncActionsResponse;
import io.voucherify.client.module.AbsModule;
import io.voucherify.client.utils.RxUtils;
import java.util.concurrent.Executor;

public final class AsyncActionsModule
extends AbsModule<ExtAsync, ExtRxJava> {
    public AsyncActionsModule(VoucherifyApi api, Executor executor) {
        super(api, executor);
    }

    public AsyncActionResponse get(String id) {
        return this.executeSyncApiCall(this.api.getAsyncAction(id));
    }

    public AsyncActionsResponse list(AsyncActionsFilter asyncActionsFilter) {
        return this.executeSyncApiCall(this.api.listAsyncActions(asyncActionsFilter.asMap()));
    }

    @Override
    ExtAsync createAsyncExtension() {
        return new ExtAsync();
    }

    @Override
    ExtRxJava createRxJavaExtension() {
        return new ExtRxJava();
    }

    @Override
    public ExtAsync async() {
        return (ExtAsync)this.extAsync;
    }

    @Override
    public ExtRxJava rx() {
        return (ExtRxJava)this.extRxJava;
    }

    public class ExtRxJava
    extends AbsModule.Rx {
        public Observable<AsyncActionResponse> get(final String id) {
            return RxUtils.defer(new RxUtils.DefFunc<AsyncActionResponse>(){

                @Override
                public AsyncActionResponse method() {
                    return AsyncActionsModule.this.get(id);
                }
            });
        }

        public Observable<AsyncActionsResponse> list(final AsyncActionsFilter asyncActionsFilter) {
            return RxUtils.defer(new RxUtils.DefFunc<AsyncActionsResponse>(){

                @Override
                public AsyncActionsResponse method() {
                    return AsyncActionsModule.this.list(asyncActionsFilter);
                }
            });
        }
    }

    public class ExtAsync
    extends AbsModule.Async {
        public void get(String id, VoucherifyCallback<AsyncActionResponse> callback) {
            RxUtils.subscribe(AsyncActionsModule.this.executor, AsyncActionsModule.this.rx().get(id), callback);
        }

        public void list(AsyncActionsFilter filter, VoucherifyCallback<AsyncActionsResponse> callback) {
            RxUtils.subscribe(AsyncActionsModule.this.executor, AsyncActionsModule.this.rx().list(filter), callback);
        }
    }
}

