/*
 * Decompiled with CFR 0.152.
 */
package io.voucherify.client;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import io.voucherify.client.ApiVersion;
import io.voucherify.client.LogLevel;
import io.voucherify.client.api.VoucherifyApi;
import io.voucherify.client.error.VoucherifyErrorHandler;
import io.voucherify.client.json.deserializer.DateDeserializer;
import io.voucherify.client.json.serializer.DateSerializer;
import io.voucherify.client.module.CampaignsModule;
import io.voucherify.client.module.CustomersModule;
import io.voucherify.client.module.DistributionsModule;
import io.voucherify.client.module.EventsModule;
import io.voucherify.client.module.LoyaltiesModule;
import io.voucherify.client.module.OrdersModule;
import io.voucherify.client.module.ProductsModule;
import io.voucherify.client.module.PromotionsModule;
import io.voucherify.client.module.RedemptionsModule;
import io.voucherify.client.module.RewardsModule;
import io.voucherify.client.module.SegmentsModule;
import io.voucherify.client.module.ValidationRulesModule;
import io.voucherify.client.module.ValidationsModule;
import io.voucherify.client.module.VoucherModule;
import io.voucherify.client.utils.Platform;
import java.util.Date;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.logging.HttpLoggingInterceptor;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.jackson.JacksonConverterFactory;

public class VoucherifyClient {
    private final String httpScheme;
    private final OrdersModule ordersModule;
    private final EventsModule eventsModule;
    private final VoucherModule voucherModule;
    private final ValidationsModule validationsModule;
    private final CustomersModule customersModule;
    private final CampaignsModule campaignsModule;
    private final RedemptionsModule redemptionsModule;
    private final DistributionsModule distributionsModule;
    private final ProductsModule productsModule;
    private final SegmentsModule segmentsModule;
    private final ValidationRulesModule validationRulesModule;
    private final PromotionsModule promotionsModule;
    private final RewardsModule rewardsModule;
    private final LoyaltiesModule loyaltiesModule;
    private VoucherifyApi voucherifyApi;
    private Executor executor;
    private VoucherifyErrorHandler errorHandler;

    private VoucherifyClient(Builder builder) {
        if (builder.clientSecretKey == null) {
            throw new IllegalArgumentException("App token must be defined.");
        }
        if (builder.appId == null) {
            throw new IllegalArgumentException("App ID must be defined.");
        }
        this.httpScheme = this.createHttpScheme(builder);
        this.executor = this.createCallbackExecutor();
        this.errorHandler = new VoucherifyErrorHandler();
        this.voucherifyApi = this.createRetrofitService(builder);
        this.voucherModule = new VoucherModule(this.voucherifyApi, this.executor);
        this.validationsModule = new ValidationsModule(this.voucherifyApi, this.executor);
        this.customersModule = new CustomersModule(this.voucherifyApi, this.executor);
        this.campaignsModule = new CampaignsModule(this.voucherifyApi, this.executor);
        this.redemptionsModule = new RedemptionsModule(this.voucherifyApi, this.executor);
        this.distributionsModule = new DistributionsModule(this.voucherifyApi, this.executor);
        this.productsModule = new ProductsModule(this.voucherifyApi, this.executor);
        this.segmentsModule = new SegmentsModule(this.voucherifyApi, this.executor);
        this.validationRulesModule = new ValidationRulesModule(this.voucherifyApi, this.executor);
        this.promotionsModule = new PromotionsModule(this.voucherifyApi, this.executor);
        this.ordersModule = new OrdersModule(this.voucherifyApi, this.executor);
        this.eventsModule = new EventsModule(this.voucherifyApi, this.executor);
        this.rewardsModule = new RewardsModule(this.voucherifyApi, this.executor);
        this.loyaltiesModule = new LoyaltiesModule(this.voucherifyApi, this.executor);
    }

    public VoucherModule vouchers() {
        return this.voucherModule;
    }

    public ValidationsModule validations() {
        return this.validationsModule;
    }

    public CustomersModule customers() {
        return this.customersModule;
    }

    public CampaignsModule campaigns() {
        return this.campaignsModule;
    }

    public RedemptionsModule redemptions() {
        return this.redemptionsModule;
    }

    public DistributionsModule distributions() {
        return this.distributionsModule;
    }

    public ProductsModule products() {
        return this.productsModule;
    }

    public SegmentsModule segments() {
        return this.segmentsModule;
    }

    public ValidationRulesModule validationRules() {
        return this.validationRulesModule;
    }

    public PromotionsModule promotions() {
        return this.promotionsModule;
    }

    public OrdersModule orders() {
        return this.ordersModule;
    }

    public EventsModule events() {
        return this.eventsModule;
    }

    public RewardsModule rewards() {
        return this.rewardsModule;
    }

    public LoyaltiesModule loyalties() {
        return this.loyaltiesModule;
    }

    private Executor createCallbackExecutor() {
        return Platform.get().callbackExecutor();
    }

    private JacksonConverterFactory createConverter(Builder builder) {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        SimpleModule jsonParsingModule = new SimpleModule();
        jsonParsingModule.addSerializer(Date.class, (JsonSerializer)new DateSerializer("yyyy-MM-dd'T'HH:mm:ssXXX"));
        jsonParsingModule.addDeserializer(Date.class, (JsonDeserializer)new DateDeserializer("yyyy-MM-dd'T'HH:mm:ssXXX", "yyyy-MM-dd'T'HH:mm:ss.SSSXXX"));
        mapper.registerModule((Module)jsonParsingModule);
        return JacksonConverterFactory.create((ObjectMapper)mapper);
    }

    private String createHttpScheme(Builder builder) {
        if (builder.secure) {
            return "https";
        }
        return "http";
    }

    private VoucherifyApi createRetrofitService(Builder builder) {
        Retrofit.Builder restBuilder = new Retrofit.Builder().addConverterFactory((Converter.Factory)this.createConverter(builder)).baseUrl(this.getBaseUrl(builder)).client(this.createClient(builder));
        return (VoucherifyApi)restBuilder.build().create(VoucherifyApi.class);
    }

    private OkHttpClient createClient(Builder builder) {
        OkHttpClient.Builder httpClient = new OkHttpClient.Builder();
        httpClient.addInterceptor(chain -> {
            Request original = chain.request();
            Request request = original.newBuilder().header("X-Voucherify-Channel", "Java-SDK").header("X-App-Id", builder.appId).header("X-App-Token", builder.clientSecretKey).header("X-Voucherify-API-Version", ((ApiVersion)((Object)((Object)ObjectUtils.firstNonNull((Object[])new ApiVersion[]{builder.apiVersion, ApiVersion.V_2018_08_01})))).getValue()).method(original.method(), original.body()).build();
            return chain.proceed(request);
        }).addInterceptor(chain -> {
            Request request = chain.request();
            Response response = chain.proceed(request);
            if (!response.isSuccessful()) {
                throw this.errorHandler.from(response);
            }
            return response;
        });
        httpClient.connectTimeout((long)((Integer)ObjectUtils.firstNonNull((Object[])new Integer[]{builder.connectionTimeout, 60})).intValue(), TimeUnit.SECONDS);
        httpClient.readTimeout((long)((Integer)ObjectUtils.firstNonNull((Object[])new Integer[]{builder.readTimeout, 60})).intValue(), TimeUnit.SECONDS);
        httpClient.writeTimeout((long)((Integer)ObjectUtils.firstNonNull((Object[])new Integer[]{builder.writeTimeout, 60})).intValue(), TimeUnit.SECONDS);
        HttpLoggingInterceptor httpLoggingInterceptor = new HttpLoggingInterceptor();
        httpLoggingInterceptor.level(((LogLevel)((Object)ObjectUtils.firstNonNull((Object[])new LogLevel[]{builder.logLevel, LogLevel.NONE}))).getValue());
        httpClient.addInterceptor((Interceptor)httpLoggingInterceptor);
        return httpClient.build();
    }

    private String getBaseUrl(Builder builder) {
        String endpoint = (String)ObjectUtils.firstNonNull((Object[])new String[]{builder.endpoint, "api.voucherify.io"});
        boolean trailingSlash = StringUtils.endsWith((CharSequence)endpoint, (CharSequence)"/");
        return String.format("%s://%s%sv1/", this.httpScheme, endpoint, trailingSlash ? "" : "/");
    }

    public static class Builder {
        String clientSecretKey;
        String appId;
        String endpoint;
        boolean secure = true;
        ApiVersion apiVersion;
        Integer connectionTimeout;
        Integer readTimeout;
        Integer writeTimeout;
        LogLevel logLevel;

        public Builder setClientSecretKey(String clientSecretKey) {
            if (clientSecretKey == null) {
                throw new IllegalArgumentException("Cannot call setClientSecretKey() with null.");
            }
            this.clientSecretKey = clientSecretKey;
            return this;
        }

        public Builder setAppId(String appId) {
            if (appId == null) {
                throw new IllegalArgumentException("Cannot call setAppId() with null.");
            }
            this.appId = appId;
            return this;
        }

        public Builder setConnectTimeout(Integer timeout) {
            this.connectionTimeout = timeout;
            return this;
        }

        public Builder setReadTimeout(Integer timeout) {
            this.readTimeout = timeout;
            return this;
        }

        public Builder setWriteTimeout(Integer timeout) {
            this.writeTimeout = timeout;
            return this;
        }

        public Builder setEndpoint(String remoteUrl) {
            if (remoteUrl == null) {
                throw new IllegalArgumentException("Cannot call setEndpoint() with null.");
            }
            this.endpoint = remoteUrl;
            return this;
        }

        public Builder setLogLevel(LogLevel logLevel) {
            if (logLevel == null) {
                throw new IllegalArgumentException("Cannot call setLogLevel() with null.");
            }
            this.logLevel = logLevel;
            return this;
        }

        public Builder withSSL() {
            this.secure = true;
            return this;
        }

        public Builder withoutSSL() {
            this.secure = false;
            return this;
        }

        public Builder apiVersion(ApiVersion version) {
            if (version == null) {
                throw new IllegalArgumentException("Cannot call apiVersion() with null.");
            }
            this.apiVersion = version;
            return this;
        }

        public VoucherifyClient build() {
            return new VoucherifyClient(this);
        }
    }
}

